// cflow2cflow v1.2
//
// Copyright (C) 2002, by
// 
// Carlo Wood, Run on IRC <carlo@alinoe.com>
// RSA-1024 0x624ACAD5 1997-01-26                    Sign & Encrypt
// Fingerprint16 = 32 EC A7 B6 AC DB 65 A6  F6 F6 55 DD 1C DC FF 61
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
#include <iostream>
#include <fstream>
#include <cerrno>
#include <cctype>
#include <cstdlib>
#include "parse.h"

class cflow2cflow_ct : public cflow_ct {
  public:
    set<std::string> requested_function_names;
    set<std::string> stop_function_names;
    function_references_ct requested_functions;
  protected:
    virtual void new_function(int depth, std::string const& funcname, std::string const&, unsigned int)
    {
      char const* p = funcname.c_str();
      std::string searchstring(p);
      set<std::string>::iterator i(requested_function_names.find(searchstring));
      if (i != requested_function_names.end())
	requested_functions.add(last_func[depth]);
      if (p[0] == '_' && p[1] == '_')
      {
	std::string searchstring(p + 2);
	set<std::string>::iterator i(requested_function_names.find(searchstring));
	if (i != requested_function_names.end())
	  requested_functions.add(last_func[depth]);
      }
      else if (p[0] != '_')
      {
	std::string searchstring = "__";
	searchstring += funcname;
	set<std::string>::iterator i(requested_function_names.find(searchstring));
	if (i != requested_function_names.end())
	  requested_functions.add(last_func[depth]);
      }
      set<std::string>::iterator j(stop_function_names.find(searchstring));
      if (j != stop_function_names.end())
	(*last_func[depth]).second.stop();
    }
};

int main(int argc, char* argv[])
{
  ifstream input_file;
  istream* input;
  bool reading_from_file = false;
  bool print_all_functions = true;
  bool inverse = false;
  bool parse_options = true;
  bool print_usage = false;
  unsigned int max_depth = static_cast<unsigned int>(-1);
  cflow2cflow_ct calltree;
  for (int arg = 1; arg < argc; ++arg)
  {
    std::string argument(argv[arg]);
    if (argument == "-")
      input = &std::cin;
    else if (parse_options && argument[0] == '-')
    {
      if (argument == "--help")
      {
	print_usage = true;
	break;
      }
      if (argument == "--version")
      {
	std::cout << "calltree v1.1, by Carlo Wood.\n";
	exit(0);
      }
      if (argument == "--inverse")
	inverse = true;
      else if (argument == "--function")
      {
	if (++arg == argc)
	{
	  print_usage = true;
	  break;
	}
        calltree.requested_function_names.insert(std::string(argv[arg]));
	print_all_functions = false;
      }
      else if (argument == "--stop")
      {
	if (++arg == argc)
	{
	  print_usage = true;
	  break;
	}
	calltree.stop_function_names.insert(std::string(argv[arg]));
      }
      else if (argument == "--depth")
      {
	if (++arg == argc)
	{
	  print_usage = true;
	  break;
	}
	max_depth = atoi(argv[arg]);
      }
      else if (argument == "--sun")
	function_ct::sun_format(true);
      else
      {
	std::cerr << "Unknown option " << argument << '\n';
	print_usage = true;
	break;
      }
    }
    else if (!reading_from_file)
    {
      input_file.open(argv[arg]);
      if (input_file)
      {
	input = &input_file;
	reading_from_file = true;
      }
      else
      {
	std::cerr << argv[0] << ": Failed to open file \"" << argv[arg] << "\".\n";
	exit(1);
      }
    }
    else
    {
      print_usage = true;
      break;
    }
  }
  if (print_usage)
  {
    std::cout << "Usage: " << argv[0] << " [options] [<input file>]\n"
	      << "Where <input file> is optional, in which case " << argv[0] << " reads from stdin.\n"
	      << "Options:\n"
	      << "--function <function name> : print only call tree of <function name>.\n"
	      << "--stop <function name>     : stop traversing into tree at this function.\n"
	      << "--depth <number>           : stop traversing into tree at this depth.\n"
	      << "--inverse                  : print inverse call tree.\n"
	      << "--                         : end of options.\n"
	      ;
    exit(0);
  }
  if (!reading_from_file)
    input = &std::cin;
  *input >> calltree;
  if (reading_from_file)
    input_file.close();
  if (print_all_functions)
    calltree.all_functions.print_on(std::cout, 0, max_depth, inverse);
  else if (calltree.requested_functions.size() > 0)
    calltree.requested_functions.print_on(std::cout, 0, max_depth, inverse);
  else
    std::cout << "Nothing found.\n";
  return 0;
}
