"""Repository module for cfvers"""


# Copyright 2003 Iustin Pop
#
# This file is part of cfvers.
#
# cfvers is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# cfvers is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with cfvers; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

import re
import cfvers

def _parse(cnxargs):
    m = re.match('^([^:]+):(.*)', cnxargs)
    if m is not None:
        bk = m.group(1)
        data = m.group(2)
        repo_module = "cfvers.repository.r_%s" % bk
        repo_classname = "%s.R%s" % (repo_module, bk.capitalize())
        try:
            exec("import %s" % repo_module)
        except ImportError, e:
            raise cfvers.ConfigException, "unknown repository type '%s' (error was '%s')" % (bk, e)
        try:
            repo_class = eval(repo_classname)
        except AttributeError, e:
            raise cfvers.ConfigException, \
                  "module %s doesn't contain needed class (%s)" \
                  % (repo_module, repo_classname)
        return repo_class, data
    else:
        raise cfvers.ConfigException, "invalid repository path '%s'" % cnxargs
    return

def open(cnxargs=None, create=False, createopts=None):
    rclass, rdata = _parse(cnxargs)
    return rclass(cnxargs=rdata, create=create,
                  createopts=createopts)

