"""Module implementing a SQLite based repository for cfvers"""

# Copyright 2003 Iustin Pop
#
# This file is part of cfvers.
#
# cfvers is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# cfvers is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with cfvers; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

import sqlite

import cfvers.repository.sql
import cfvers

class RSqlite(cfvers.repository.sql.RSql):
    def __init__(self, create=False, cnxargs=None, createopts=None):
        self.conn = sqlite.connect(cnxargs)
        self.backend = "sqlite"
        self.cnxargs = cnxargs
        if create:
            self._create(createopts=createopts)
        return

    def areas(self):
        cursor = self.conn.cursor()
        cursor.execute("select name, root, ctime, description from areas")
        c2 = self.conn.cursor()
        areas = []
        for row in cursor.fetchall():
            c2.execute("select count(*) from items where items.area = %s", (row[0],))
            nitems = int(c2.fetchone()[0])
            c2.execute("select max(revno) from arearevs where area = %s", (row[0],))
            revno = c2.fetchone()[0]
            if revno is not None:
                revno = int(revno)
            areas.append(cfvers.Area(name=row[0], root=row[1], ctime=row[2],
                                     numitems=nitems, revno=revno,
                                     description=row[3]))
        return areas
    
    def getArea(self, name):
        cursor = self.conn.cursor()
        cursor.execute("select name, root, ctime, description from areas where name = %s", (name,))
        row = cursor.fetchone()
        if row is None:
            return None
        c2 = self.conn.cursor()
        c2.execute("select count(*) from items where items.area = %s", (name,))
        nitems = int(c2.fetchone()[0])
        c2.execute("select max(revno) from arearevs where area = %s", (name,))
        revno = c2.fetchone()[0]
        if revno is not None:
            revno = int(revno)
        area = cfvers.Area(name=row[0], root=row[1], ctime=row[2],
                           numitems=nitems, revno=revno,
                           description=row[3])
        return area
    
