"""Repository module for cfvers"""

# Copyright 2003-2005 Iustin Pop
#
# This file is part of cfvers.
#
# cfvers is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# cfvers is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with cfvers; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

# $Id: __init__.py 219 2005-10-30 10:13:57Z iusty $

import re
import sys

import cfvers

def _parse(cnxmethod, cnxargs):
    if cnxmethod is None or cnxargs is None:
        raise cfvers.ConfigException, "no repository given"
    repo_module = "cfvers.repository.r_%s" % cnxmethod
    repo_classname = "%s.R%s" % (repo_module, cnxmethod.capitalize())
    try:
        exec("import %s" % repo_module)
    except ImportError, e:
        raise cfvers.ConfigException, "unknown repository type '%s' (error was '%s')" % (cnxmethod, e)
    try:
        repo_class = eval(repo_classname)
    except AttributeError, e:
        raise cfvers.ConfigException, \
              "module %s doesn't contain needed class (%s)" \
              % (repo_module, repo_classname)
    return repo_class, cnxargs

def open(cnxmethod=None, cnxargs=None, create=False, createopts=None):
    rclass, rdata = _parse(cnxmethod, cnxargs)
    try:
        rinst = rclass(cnxargs=rdata, create=create,
                       createopts=createopts)
    except:
        raise cfvers.RepositoryException, sys.exc_info()[1]
    return rinst
