% plot 3d box with quiver-fields on two faces 
% using u,v,w, data from figgen.x

load x.asc; load y.asc; load z.asc
load usec.asc; load wsec.asc; load vsec.asc; 

%z = z-1.2*pi;
Nx = length(x);
Ny = length(y);
Nz = length(z);

clf;
hold on;

% Patch
c = 0.95*[1 1 1];

xmin=min(x);
ymin=min(y);
zmin=min(z);
xmax=max(x);
ymax=max(y);
zmax=max(z);

pX(1) = xmin;
pY(1) = ymax;
pZ(1) = zmin;

pX(2) = xmax;
pY(2) = ymax;
pZ(2) = zmin;

pX(3) = xmax;
pY(3) = ymax;
pZ(3) = zmax;

pX(4) = xmin;
pY(4) = ymax;
pZ(4) = zmax;

pX(5) = xmin;
pY(5) = ymax;
pZ(5) = zmin;

fill3(pZ,pX,pY,c);
fill3(pZ,pX,-pY,c);

plot3([zmin zmin], [xmin xmin], [ymin ymax]);
plot3([zmin zmin], [xmax xmax], [ymin ymax]);
plot3([zmax zmax], [xmin xmin], [ymin ymax]);
plot3([zmax zmax], [xmax xmax], [ymin ymax]);

ushift = zeros(Ny,Nz);
wshift = zeros(Ny,Nz);
vshift = zeros(Ny,Nz);
shift = 6; % chosen because it looks good for a part. data set
for nz=1:Nz
  ushift(:,nz) = usec(:,mod(nz+shift,Nz)+1);
  vshift(:,nz) = vsec(:,mod(nz+shift,Nz)+1);
  wshift(:,nz) = wsec(:,mod(nz+shift,Nz)+1);
end

n=1;
yloop=1:2:Ny;
zloop=1:1:Nz;
N = length(yloop)*length(zloop);
X=zeros(N,1);
Y=zeros(N,1);
Z=zeros(N,1);
U=zeros(N,1);
V=zeros(N,1);
W=zeros(N,1);

for ny=yloop
  for nz=zloop
    X(n) = max(x);
    Y(n) = y(ny);
    Z(n) = z(nz);
    U(n) = 0.0; % ushift(ny,nz);
    V(n) = vshift(ny,nz);
    W(n) = wshift(ny,nz);
    n = n+1;
  end
end

quiver3(Z,X,Y,W,U,V,'.');

load uside.asc; load vside.asc; load wside.asc;

n=1;
xloop=1:1:Nx;
yloop=1:2:Ny;
N = length(xloop)*length(yloop);
X=zeros(N,1);
Y=zeros(N,1);
Z=zeros(N,1);
U=zeros(N,1);
V=zeros(N,1);
W=zeros(N,1);

for ny=yloop
  for nx=xloop
    X(n) = x(nx);
    Y(n) = y(ny);
    Z(n) = max(z);
    U(n) = uside(ny,nx)  + y(ny);
    V(n) = vside(ny,nx);
    W(n) = 0.0; % wside(ny,nx);
    n = n+1;
  end
end
quiver3(Z,X,Y,W,U,V,2,'.');
xlabel('z');
ylabel('x');
zlabel('y');
axis equal
axis off

       % Z X Y
view([12 10 3])