#ifndef TURBSTATS_H
#define TURBSTATS_H
//#include "array.h"
#include "mathdefs.h"
#include "chebyshev.h"
#include "basisfunc.h"
#include "flowfield.h"

class TurbStats {
public:
  TurbStats();
  TurbStats(const string& filebase);
  TurbStats(const ChebyCoeff& Ubase, Real nu);

  void addData(FlowField& u, FlowField& tmp);
  void msave(const string& filebase, bool wallunits=false) const;

  ChebyCoeff Umean() const;  // average flow
  ChebyCoeff ubase() const;  // average fluctuation on base flow
  ChebyCoeff uu() const;
  ChebyCoeff uv() const;
  ChebyCoeff uw() const;
  ChebyCoeff vv() const;
  ChebyCoeff vw() const;
  ChebyCoeff ww() const;
  ChebyCoeff dUdy() const;

  // wall unit stuff
  Real ustar() const;   
  Real parabolicReynolds() const;  // h Uparab/nu, center vel of parab w = flux
  Real bulkReynolds() const;       // h Ubulk/nu
  Real centerlineReynolds() const; // h Ucenterline/nu
  Vector yplus() const;

private:
  int count_;
  Real nu_;          // All ChebyCoeff quantities are sums for means, in utot
  ChebyCoeff Ubase_; // base flow (parabolas, etc).
  ChebyCoeff Umean_; // mean flow = avg(utot)
  ChebyCoeff ubase_; // mean fluc above base flow: utot = Ubase + ubase
  ChebyCoeff uu_;    // sum_1^count utot utot
  ChebyCoeff uv_;
  ChebyCoeff uw_;
  ChebyCoeff vv_;
  ChebyCoeff vw_;
  ChebyCoeff ww_;
};

  


#endif // TURBSTATS
