#include <iostream>
#include "chebyshev.h"

int main() {

  int N=65;
  Real a = -1;
  Real b = 1;
  ChebyCoeff f(N, a, b, Physical);
  ChebyCoeff fy(N, a, b, Physical);
  ChebyCoeff fyy(N, a, b, Physical);
  
  Vector y = chebypoints(N, a, b);
  y.save("y");
  for (int n=0; n<N; ++n) {
    Real yn = y[n];
    //f[n] = 1-square(yn); //sin(yn);
    //fy[n] = -2*yn; // -2*cos(yn);
    //fyy[n] = -2; // -sin(yn);
    f[n] = sin(yn);
    fy[n] = cos(yn);
    fyy[n] = -sin(yn);
  }

  ChebyTransform t(N);

  ChebyCoeff g(f);
  t.chebyfft(g);
  
  ChebyCoeff gy;
  diff(g, gy);
  
  ChebyCoeff gyy = diff2(g);

  ChebyCoeff Ig = integrate(g);
  ChebyCoeff DIg = diff(Ig); 
  cout << "L1Dist(diff(integrate(g)), g) == " << L1Dist(DIg, g) << endl;
  
  ChebyCoeff Igy = integrate(gy);
  Igy[0] = g[0];
  cout << "L1Dist(integrate(diff(gy)), g) == " << L1Dist(Igy, g)  << endl;

  t.ichebyfft(g);
  t.ichebyfft(gy);
  t.ichebyfft(gyy);
  t.ichebyfft(Ig);
  t.ichebyfft(Igy);
  t.ichebyfft(DIg);


  cout << "d/dy   error = " << L1Norm(fy-gy) << endl;
  cout << "d2/dy2 error = " << L1Norm(fyy-gyy) << endl;
  cout << "transform/inverse error = " << L1Norm(f-g) << endl;

  g.save("g");
  gyy.save("gyy");
  gy.save("gy");
  Igy.save("Igy");
  DIg.save("DIg");
  Ig.save("Ig");
  fyy.save("fyy");
  fy.save("fy");
  f.save("f");
  
  ComplexChebyCoeff h(N, a, b, Physical);
  for (int i=0; i<N; ++i) {
    h.re[i] = i;
    h.im[i] = i/10.0;
  }
  h.save("h");
  
  ComplexChebyCoeff h2(h);
  cout << "ComplexChebyCoeff IO error == " << L2Dist(h,h2) << endl;

  Complex zero = 0.0 + 0.0*I;
  for (int n=0; n<N; ++n) 
    h.set(n, zero);
  h.setState(Spectral);

  h.set(0, 1.0 + 0.0*I);
  t.ichebyfft(h);
  h.save("T0");
  t.chebyfft(h);
  h.set(0, zero);

  h.set(1, 1.0 + 0.0*I);
  t.ichebyfft(h);
  h.save("T1");
  t.chebyfft(h);
  h.set(1, zero);

  h.set(2, 1.0 + 0.0*I);
  t.ichebyfft(h);
  h.save("T2");
  t.chebyfft(h);
  h.set(1, zero);

  h.set(2, 1.0 + 0.0*I);
  t.ichebyfft(h);
  h.save("T2");
  t.chebyfft(h);
  h.set(2, zero);

  h.set(3, 1.0 + 0.0*I);
  t.ichebyfft(h);
  h.save("T3");
  t.chebyfft(h);
  h.set(3, zero);


  
  g.randomize(0.5);
  cout << endl;
  cout << "ChebyCoeff norms and normalization check: " << endl;
  cout << "normalized L2Norm(g)  == " << L2Norm(g, true) << endl;
  cout << "setting g' = g/(normalized L2Norm(g))" << endl;
  g *= 1.0/(L2Norm(g,true));
  cout << "normalized L2Norm(g') == " << L2Norm(g, true) << endl;

  cout << endl;
  cout << "randomizing g" << endl;
  g.randomize(0.5);
  cout << "L2Norm(g)  == " << L2Norm(g) << endl;
  cout << "setting g' = g/L2Norm(g)" << endl;
  g *= 1.0/(L2Norm(g));
  cout << "L2Norm(g') == " << L2Norm(g) << endl;

  h.randomize(0.5);
  cout << endl;
  cout << "ComplexChebyCoeff norms and normalization check: " << endl;
  cout << "normalized L2Norm(h)  == " << L2Norm(h, true) << endl;
  cout << "setting h' = h/(normalized L2Norm(h))" << endl;
  h *= 1.0/(L2Norm(h,true));
  cout << "normalized L2Norm(h') == " << L2Norm(h, true) << endl;

  cout << endl;
  cout << "randomizing h" << endl;
  h.randomize(0.5);
  cout << "L2Norm(h)  == " << L2Norm(h) << endl;
  cout << "setting h' = h/L2Norm(h)" << endl;
  h *= 1.0/(L2Norm(h));
  cout << "L2Norm(h') == " << L2Norm(h) << endl;
}
