#include <iostream>
#include "chebyshev.h"

int main() {

  bool save = false;
  bool verbose = true;

  Real error = 0.0;
  Real epsilon = 1e-12;

  Real difffactor = 1e3; // allows error increase for successive derivatives
  int N=65;
  Real a = -1;
  Real b = 1;
  ChebyCoeff f(N, a, b, Physical);
  ChebyCoeff fy(N, a, b, Physical);
  ChebyCoeff fyy(N, a, b, Physical);
  
  Vector y = chebypoints(N, a, b);
  if (save) 
    y.save("y");
  for (int n=0; n<N; ++n) {
    Real yn = y[n];
    //f[n] = 1-square(yn); //sin(yn);
    //fy[n] = -2*yn; // -2*cos(yn);
    //fyy[n] = -2; // -sin(yn);
    f[n] = sin(yn);
    fy[n] = cos(yn);
    fyy[n] = -sin(yn);
  }

  ChebyTransform t(N);

  ChebyCoeff g(f);
  t.chebyfft(g);
  
  ChebyCoeff gy;
  diff(g, gy);
  
  ChebyCoeff gyy = diff2(g);

  ChebyCoeff Ig = integrate(g);
  ChebyCoeff DIg = diff(Ig); 
  
  Real err = L1Dist(DIg, g);
  error += err;
  if (verbose)
    cout << "L1Dist(diff(integrate(g)), g) == " << err << endl;
  
  ChebyCoeff Igy = integrate(gy);
  Igy[0] = g[0];
  err = L1Dist(Igy, g);
  error += err;
  if (verbose)
    cout << "L1Dist(integrate(diff(gy)), g) == " << err  << endl;

  t.ichebyfft(g);
  t.ichebyfft(gy);
  t.ichebyfft(gyy);
  t.ichebyfft(Ig);
  t.ichebyfft(Igy);
  t.ichebyfft(DIg);

  err = L1Norm(f-g);
  error += err;
  if (verbose)
    cout << "trans  error == " << err << endl;

  err = L1Norm(fy-gy);
  error += err/difffactor;
  if (verbose)
    cout << "d/dy   error == " << err << endl;

  err = L1Norm(fyy-gyy);
  error += err/square(difffactor);
  if (verbose)
    cout << "d2/dy2 error == " << err << endl;

  if (save) {
    g.save("g");
    gyy.save("gyy");
    gy.save("gy");
    Igy.save("Igy");
    DIg.save("DIg");
    Ig.save("Ig");
    fyy.save("fyy");
    fy.save("fy");
    f.save("f");
  }
  
  ComplexChebyCoeff h(N, a, b, Physical);
  h.randomize(1.0, 0.6);
  h.save("h");

  ComplexChebyCoeff h2("h");
  err = L2Dist(h,h2);
  error += err;

  if (verbose)
    cout << "ComplexChebyCoeff IO error == " << err << endl;


  if (save) {
    Complex zero = 0.0 + 0.0*I;
    for (int n=0; n<N; ++n) 
      h.set(n, zero);
    h.setState(Spectral);

    h.set(0, 1.0 + 0.0*I);
    t.ichebyfft(h);
    h.save("T0");
    t.chebyfft(h);
    h.set(0, zero);

    h.set(1, 1.0 + 0.0*I);
    t.ichebyfft(h);
    h.save("T1");
    t.chebyfft(h);
    h.set(1, zero);

    h.set(2, 1.0 + 0.0*I);
    t.ichebyfft(h);
    h.save("T2");
    t.chebyfft(h);
    h.set(1, zero);

    h.set(2, 1.0 + 0.0*I);
    t.ichebyfft(h);
    h.save("T2");
    t.chebyfft(h);
    h.set(2, zero);

    h.set(3, 1.0 + 0.0*I);
    t.ichebyfft(h);
    h.save("T3");
    t.chebyfft(h);
    h.set(3, zero);
  }
  
  if (error < epsilon) {
    cout << "PASS" << endl;
    return 0;
  }
  else {
    cout << "FAIL" << endl;
    return 1;
  }
}
