#ifndef HELPERFUNCS_H
#define HELPERFUNCS_H

#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>
#include "flowfield.h"
#include "vector.h"
#include "chebyshev.h"
#include "basisfunc.h"
#include "nsintegrator.h"

void xavg(const FlowField& un, FlowField& unxavg);
void saveplots(const string& lbl, FlowField& un, FlowField& unMean, 
	       ChebyTransform& tr,
	       ostream& modestream, ostream& dragstream);

//void savecoeffs(ComplexVector& an, ostream& os);
void ucheck(const FlowField& un, const NSIntegrator& dns, Real dt, Real t, 
	    const string& label);
void modifyPressure(FlowField& p, FlowField& u, int sign);
void symmetrize(BasisFunc& umean);

#endif
