#! /bin/sh
### checkurls --- Check if some files were changed.

## Copyright (C)  2002,2003  Marco Parrone.

## Author: Marco Parrone
## Maintainer: Marco Parrone <marc0@autistici.org>
## Keywords: URL changes monitor checker
## Language: Shell

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

### Commentary:

## This script reads a list of URLs and calls checkurl for each one.

### Code:

m4_include(config.m4)
m4_changequote({{{, }}})

## Sets the default values.

case $CUS_VERSION in
    "") CUS_VERSION=$CONF_VERSION ;;
esac

case $CUS_QUIET in
    "") CUS_QUIET="no" ;;
esac

case $CUS_VERBOSE in
    "") CUS_VERBOSE="no" ;;
esac

case $CHECKURL_FLAGS in
    "") CHECKURL_FLAGS="" ;;
esac

case $CUS_CONF_FILE in
    "") CUS_CONF_FILE=$HOME/.checkurls_conf.sh ;;
esac

case $CUS_URLS_FILE in
    "") CUS_URLS_FILE=$HOME/.checkurls_conf.txt ;;
esac

case $CUS_URL_SPEC_OPTS in
    "") CUS_URL_SPEC_OPTS=$HOME/.checkurls_url_spec_opts.sh ;;
esac

## Parse the command line options.

TMP=`getopt -o hVc:qvC: --long help,version,conf:,quiet,verbose,checkurl-flags: -n checkurls -- ${1+"$@"}`

if test $? != 0 ; then
    exit 1
fi

eval set -- "$TMP"

while true ; do
    case "$1" in
	-h|--help)
	echo "checkurls $CUS_VERSION"
	echo
	echo "Purpose:"
	echo "  checkurls is a checker for remote files."
	echo
	echo "Usage: checkurls [OPTIONS]..."
	echo "   -h           --help                   Print help and exit"
	echo "   -V           --version                Print version and exit"
	echo "   -c FILENAME  --conf=FILENAME          Set the configuration file"
	echo "   -C FLAGS     --checkurl-flags=FLAGS   Options for checkurl"
	echo "   -q           --quiet                  Run in quiet mode."
	echo "   -v           --verbose                Run in verbose mode."
	shift ; exit 0 ;;
	-V|--version)
	echo "checkurls $CUS_VERSION"
	shift ; exit 0 ;;
	-c|--conf)
	CUS_CONF_FILE=$2
	shift 2 ;;
	
	-C|--checkurl-flags)
	ARG_CHECKURL_FLAGS=$2
	shift 2 ;;
	-q|--quiet)
	ARG_CUS_QUIET="yes"
	shift ;;
	-v|--verbose)
	ARG_CUS_VERBOSE="yes"
	shift ;;
	--) shift ; break ;;
	*) echo "Internal error!" ; exit 1 ;;
    esac
done

## Load in the configuration file.

if test -f $CUS_CONF_FILE ; then

    case $CUS_VERBOSE in
	"yes") echo "Loading configuration file \"$CU_CONFIG_FILE\"." ;;
    esac

  . $CUS_CONF_FILE

fi

## Set the command line options.

case $ARG_CHECKURL_FLAGS in
    "") ;;
    *) CHECKURL_FLAGS=$ARG_CHECKURL_FLAGS ;;
esac

case $ARG_CUS_QUIET in
    "") ;;
    *) CUS_QUIET=$ARG_CUS_QUIET ;;
esac

case $ARG_CUS_VERBOSE in
    "") ;;
    *) CUS_VERBOSE=$ARG_CUS_VERBOSE ;;
esac

## Load the URLs file.

if test -r $CUS_URLS_FILE ; then :; else
    echo "checkurls: Cannot load URLs file."
    exit 1
fi

case $CUS_VERBOSE in
    "yes") echo "Loading URLs file: \"$CUS_URLS_FILE\"." ;;
esac

URLS=`cat $CUS_URLS_FILE`

## Load the URL specific options file.

if test -r $CUS_URL_SPEC_OPTS ; then
    . $CUS_URL_SPEC_OPTS
fi

## Do the job.

for URL in $URLS ; do

  case $CUS_QUIET in
      "no") echo "Checking \"$URL\"." ;;
  esac

  eval URL_SPEC_OPTS='$'`echo $URL | tr ':./?=~\-' _______`

  case $CUS_VERBOSE in
      "yes") echo "URL specific options: \"$URL_SPEC_OPTS\"." ;;
  esac

  checkurl $CHECKURL_FLAGS $URL_SPEC_OPTS $URL

done

#### checkurls ends here
