/*
 *  ChkTeX v1.5, SCMSG interface.
 *  Copyright (C) 1996 Jens T. Berger Thielemann
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact the author at:
 *		Jens Berger
 *		Spektrumvn. 4
 *		N-0666 Oslo
 *		Norway
 *		E-mail: <jensthi@ifi.uio.no>
 *
 *
 */

ScMsgPath = "SC:C/SCMSG"

/* NO GENERAL USER MODIFIABLE PARTS BELOW THIS COMMENT. */

Options Failat 21

If Arg(1, "O") Then Do
	Call AddLib "rexxreqtools.library", 0, -30, 0

	/* Use reqtools if possible */

	If Show("Libraries","rexxreqtools.library") Then Do
		FileName = rtFileRequest( , , "Select LaTeX file", , "rtfi_flags = freqf_patgad" , )
		If RTResult = 0 Then Exit
	End
	Else Do
		Options Prompt "LaTeXFILE/A: "
		Pull FileName
		FileName = Strip(FileName)
	End
	If FileName = "" Then Exit
End
Else FileName = Arg(1)

TmpFile = "PIPE:ChkTeX_Temporary_Output"
CmdLine = 'Run <nil: >nil: ChkTeX -b0q -f "%f::%l::%n::%k::%m*N"' FileName '-o' TmpFile

Address Command CmdLine

If RC = 0 Then Do
	If ~Show('ports', 'SC_SCMSG') Then Address Command 'Run <nil: >nil:' SCMSGPATH

	If Open('File', TmpFile, 'R') Then Do
		Address Command 'WaitForPort SC_SCMSG'

		If ~Show('ports', 'SC_SCMSG') Then Do
			Call AddLib("rexxreqtools.library", 0, -30, 0)
			If Show("Libraries","rexxreqtools.library") Then Do
				Call rtEZRequest "Couldn't start ScMsg, giving up.", "Buhu!"
			End
			Else Do
				Say "Couldn't start ScMsg, giving up."
			End
			
			/* This is the way to "kill" a pipe: file */

			Address Command 'Run <nil: >nil: Type' TmpFile
			Exit
		End

		Address 'SC_SCMSG'
		DelFile FileName
		Show Activate
		Do Until Eof('File')
			Line = ReadLn('File')
			Parse Var Line File '::' Line '::' ErrNum '::' Kind '::' Msg
			NewMsg '"'||FileName||'"' '"'||FileName||'"' Line '0 "" 0' Kind ErrNum Msg
		End
		Call Close 'File'
	End
End
