/*

  This is the file pinyin.c of the CJK macro package ver. 4.6.0
  (11-Aug-2005).

  Use this file to generate a hyphenation input file for patgen.

  Usage:

    pinyin > pinyin.dic

 */

#include <stdio.h>


/* A list of all Chinese syllables.  We use latin-1 encoding for the
   `umlaut u' character. */

char *py[] =
{
  "a",
  "ai",
  "an",
  "ang",
  "ao",
  "ba",
  "bai",
  "ban",
  "bang",
  "bao",
  "bei",
  "ben",
  "beng",
  "bi",
  "bian",
  "biao",
  "bie",
  "bin",
  "bing",
  "bo",
  "bu",
  "ca",
  "cai",
  "can",
  "cang",
  "cao",
  "ce",
  "cen",
  "ceng",
  "cha",
  "chai",
  "chan",
  "chang",
  "chao",
  "che",
  "chen",
  "cheng",
  "chi",
  "chong",
  "chou",
  "chu",
  "chuai",
  "chuan",
  "chuang",
  "chui",
  "chun",
  "chuo",
  "ci",
  "cong",
  "cou",
  "cu",
  "cuan",
  "cui",
  "cun",
  "cuo",
  "da",
  "dai",
  "dan",
  "dang",
  "dao",
  "de",
  "dei",
  "deng",
  "di",
  "dian",
  "diao",
  "die",
  "ding",
  "diu",
  "dong",
  "dou",
  "du",
  "duan",
  "dui",
  "dun",
  "duo",
  "e",
  "ei",
  "en",
  "eng",
  "er",
  "fa",
  "fan",
  "fang",
  "fei",
  "fen",
  "feng",
  "fiao",
  "fo",
  "fou",
  "fu",
  "ga",
  "gai",
  "gan",
  "gang",
  "gao",
  "ge",
  "gei",
  "gen",
  "geng",
  "gong",
  "gou",
  "gu",
  "gua",
  "guai",
  "guan",
  "guang",
  "gui",
  "gun",
  "guo",
  "ha",
  "hai",
  "han",
  "hang",
  "hao",
  "he",
  "hei",
  "hen",
  "heng",
  "hong",
  "hou",
  "hu",
  "hua",
  "huai",
  "huan",
  "huang",
  "hui",
  "hun",
  "huo",
  "ji",
  "jia",
  "jian",
  "jiang",
  "jiao",
  "jie",
  "jin",
  "jing",
  "jiong",
  "jiu",
  "ju",
  "juan",
  "jue",
  "jun",
  "ka",
  "kai",
  "kan",
  "kang",
  "kao",
  "ke",
  "kei",
  "ken",
  "keng",
  "kong",
  "kou",
  "ku",
  "kua",
  "kuai",
  "kuan",
  "kuang",
  "kui",
  "kun",
  "kuo",
  "la",
  "lai",
  "lan",
  "lang",
  "lao",
  "le",
  "lei",
  "leng",
  "li",
  "lia",
  "lian",
  "liang",
  "liao",
  "lie",
  "lin",
  "ling",
  "liu",
  "long",
  "lou",
  "lu",
  "luan",
  "lun",
  "luo",
  "l",
  "le",
  "ma",
  "mai",
  "man",
  "mang",
  "mao",
  "me",
  "mei",
  "men",
  "meng",
  "mi",
  "mian",
  "miao",
  "mie",
  "min",
  "ming",
  "miu",
  "mo",
  "mou",
  "mu",
  "na",
  "nai",
  "nan",
  "nang",
  "nao",
  "ne",
  "nei",
  "nen",
  "neng",
  "ni",
  "nian",
  "niang",
  "niao",
  "nie",
  "nin",
  "ning",
  "niu",
  "nong",
  "nou",
  "nu",
  "nuan",
  "nuo",
  "n",
  "ne",
  "o",
  "ou",
  "pa",
  "pai",
  "pan",
  "pang",
  "pao",
  "pei",
  "pen",
  "peng",
  "pi",
  "pian",
  "piao",
  "pie",
  "pin",
  "ping",
  "po",
  "pou",
  "pu",
  "qi",
  "qia",
  "qian",
  "qiang",
  "qiao",
  "qie",
  "qin",
  "qing",
  "qiong",
  "qiu",
  "qu",
  "quan",
  "que",
  "qun",
  "ran",
  "rang",
  "rao",
  "re",
  "ren",
  "reng",
  "ri",
  "rong",
  "rou",
  "ru",
  "ruan",
  "rui",
  "run",
  "ruo",
  "sa",
  "sai",
  "san",
  "sang",
  "sao",
  "se",
  "sen",
  "seng",
  "sha",
  "shai",
  "shan",
  "shang",
  "shao",
  "she",
  "shei",
  "shen",
  "sheng",
  "shi",
  "shou",
  "shu",
  "shua",
  "shuai",
  "shuan",
  "shuang",
  "shui",
  "shun",
  "shuo",
  "si",
  "song",
  "sou",
  "su",
  "suan",
  "sui",
  "sun",
  "suo",
  "ta",
  "tai",
  "tan",
  "tang",
  "tao",
  "te",
  "tei",
  "teng",
  "ti",
  "tian",
  "tiao",
  "tie",
  "ting",
  "tong",
  "tou",
  "tu",
  "tuan",
  "tui",
  "tun",
  "tuo",
  "wa",
  "wai",
  "wan",
  "wang",
  "wei",
  "wen",
  "weng",
  "wo",
  "wu",
  "xi",
  "xia",
  "xian",
  "xiang",
  "xiao",
  "xie",
  "xin",
  "xing",
  "xiong",
  "xiu",
  "xu",
  "xuan",
  "xue",
  "xun",
  "ya",
  "yan",
  "yang",
  "yao",
  "ye",
  "yi",
  "yin",
  "ying",
  "yo",
  "yong",
  "you",
  "yu",
  "yuan",
  "yue",
  "yun",
  "za",
  "zai",
  "zan",
  "zang",
  "zao",
  "ze",
  "zei",
  "zen",
  "zeng",
  "zha",
  "zhai",
  "zhan",
  "zhang",
  "zhao",
  "zhe",
  "zhei",
  "zhen",
  "zheng",
  "zhi",
  "zhong",
  "zhou",
  "zhu",
  "zhua",
  "zhuai",
  "zhuan",
  "zhuang",
  "zhui",
  "zhun",
  "zhuo",
  "zi",
  "zong",
  "zou",
  "zu",
  "zuan",
  "zui",
  "zun",
  "zuo"
};


int main(void)
{
  int i, j, off;
  size_t size = sizeof (py) / sizeof (char*);
  char s[20];

  /* Now we loop through all possible syllable combinations. */

  for (i = 0; i < size; i++)
    for (j = 0; j < size; j++)
    {
      /* The seldom used `%n' construct yields the number of processed
         characters so far. */

      sprintf(s, "%s%n%s", py[i], &off, py[j]);

      /* We check the first character of the second syllable.  If it is
         a vowel, a quote will be inserted.  Example: Tian'anmen. */

      if (s[off] == 'a' || s[off] == 'e' || s[off] == 'o')
        printf("%s'-%s\n", py[i], py[j]);

      /* No special case. */

      else
        printf("%s-%s\n", py[i], py[j]);
    }

  return 0;
}
