/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 1999-2004, 2007 Andreas Hundt, Denis Oliver Kropp
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "ClanBomber.h"
#include "Controller_RCMouse.h"

/**DFBEnumerationResult input_enum_callback( unsigned int id, DFBInputDeviceDescription desc, void *data )
{
	if (desc.type & DIDTF_REMOTE) {
		*((int*)data) = id;
	}

	return DFENUM_OK; 
}
**/

Controller_RCMouse::Controller_RCMouse(int id) : Controller()
{
        /**DFBResult ret;

	if (id < 0) {
		dfb->EnumInputDevices( dfb, input_enum_callback, &id );
	}

	if (id < 0) {
		cerr << "FATAL: Controller_RCMouse could not find a remote device!\n";
	}
	ret = dfb->GetInputDevice( dfb, id, &rcmouse );
	if (ret) {
		DirectFBErrorFatal( "Controller_RCMouse: GetInputDevice", ret );
	}
	rcmouse->CreateEventBuffer( rcmouse, &rcbuffer );

	reset();**/
}

Controller_RCMouse::~Controller_RCMouse()
{
        ///rcmouse->Release( rcmouse );
	///rcbuffer->Release( rcbuffer );
}

void Controller_RCMouse::update()
{
        /**DFBInputEvent evt;

	put_bomb = false;

	while (rcbuffer->GetEvent( rcbuffer, DFB_EVENT(&evt) ) == DFB_OK) {
		switch (evt.type) {
			case DIET_KEYPRESS:
				if (evt.key_symbol != DIKS_OK) {
					break;
				}
			case DIET_BUTTONPRESS:
				put_bomb = true;
				break;
			case DIET_AXISMOTION:
				if (evt.flags & DIEF_AXISREL) {
					switch (evt.axis) {
						case DIAI_X:
							axis_x += evt.axisrel;
							break;
						case DIAI_Y:
							axis_y += evt.axisrel;
							break;
						default:
							;
					}
				}
				break;
			default:
				;
		}
	}

	if (active) {
		bool new_left  = (axis_x < -2);
		bool new_right = (axis_x >  2);
		bool new_up    = (axis_y < -2);
		bool new_down  = (axis_y >  2);

		if (new_left || new_right || new_up || new_down) {
			dir_pressed = true;

			if (new_left && new_up) {
				if (down || up) {
					new_left = false;
				}
				if (right || left) {
					new_up = false;
				}
			}
			else if (new_left && new_down) {
				if (down || up) {
					new_left = false;
				}
				if (right || left) {
					new_down=false;
				}
			}
			else if (new_right && new_up) {
				if (down || up) {
					new_right = false;
				}
				if (right || left) {
					new_up = false;
				}
			}
			else if (new_right && new_down) {
				if (down || up) {
					new_right = false;
				}
				if (right || left) {
					new_down = false;
				}
			}
			if (reverse) {
				left = new_right;
				right = new_left;
				up = new_down;
				down = new_up;         
			}
			else {
				left = new_left;
				right = new_right;
				up = new_up;
				down = new_down;
			}
		}
		else {
			dir_pressed = false;
		}
	}
	else {
		left = right = up = down = false;
	}

	axis_x /= 2;
	axis_y /= 2;**/
}

void Controller_RCMouse::reset()
{
	put_bomb = false;
	reverse = false;
	dir_pressed = false;
	axis_x = axis_y = 0;

	///rcbuffer->Reset( rcbuffer );
}

bool Controller_RCMouse::is_left()
{
	return left && dir_pressed && active;
}

bool Controller_RCMouse::is_right()
{
	return right && dir_pressed && active;
}

bool Controller_RCMouse::is_up()
{
	return up && dir_pressed && active;
}

bool Controller_RCMouse::is_down()
{
	return down && dir_pressed && active;
}

bool Controller_RCMouse::is_bomb()
{
	if (!active) {
		return false;
	}

	switch (bomb_mode) {
		case NEVER:
			return false;
		case ALWAYS:
			return true;
		default:
			break;
	}

	return put_bomb;
}
