/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 1999-2004, 2007 Andreas Hundt, Denis Oliver Kropp
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "ClanBomber.h"
#include "Config.h"

#include "Credits.h"

#include "Corpse_Part.h"
#include "Timer.h"

#include "Utils.h"

#include <vector>
#include "SDL.h"

#define SCROLL_SPEED 400

Credits::Credits( ClanBomberApplication *_app )
{
    app = _app;

    text.push_back(new std::string(_("ClanBomber2 Credits")));
    text.push_back(new std::string(""));
    text.push_back(new std::string(_("Game Design")));
    text.push_back(new std::string("Andreas Hundt"));
    text.push_back(new std::string("Denis Oliver Kropp"));
    text.push_back(new std::string(""));
    text.push_back(new std::string(_("Coding")));
    text.push_back(new std::string("Denis Oliver Kropp"));
    text.push_back(new std::string("Andreas Hundt"));
    text.push_back(new std::string("mass"));
    text.push_back(new std::string(_("(network code and oza stuf)")));
    text.push_back(new std::string(""));
    text.push_back(new std::string(_("Graphics")));
    text.push_back(new std::string("Andreeshchev Eugeni"));
    text.push_back(new std::string("Denis Oliver Kropp"));
    text.push_back(new std::string("Andreas Hundt"));
    text.push_back(new std::string(""));
    text.push_back(new std::string(_("Thanks go out to:")));
    text.push_back(new std::string("Magnus Norddahl"));
    text.push_back(new std::string(_("(24h ClanLib support)")));
    text.push_back(new std::string("Fredrik Hallenberg"));
    text.push_back(new std::string(_("(Debian package maintainer)")));
    text.push_back(new std::string("non"));
    text.push_back(new std::string(_("(for creating horst (the guy to the left))")));
    text.push_back(new std::string("clanner and resix"));
    text.push_back(new std::string(_("(for creating maps and playing with us)")));
    text.push_back(new std::string("Ivar"));
    text.push_back(new std::string(_("(for creating maps)")));
    text.push_back(new std::string("Magnus Reftel"));
    text.push_back(new std::string(_("(disable shaky explosions patch)")));
    text.push_back(new std::string("the xtux creators"));
    text.push_back(new std::string(_("(for the original tux and bsd-devil graphics)")));
    text.push_back(new std::string("SuSE Linux AG"));
    text.push_back(new std::string(_("(for donating free SuSE Linux Professionial packages)")));
    text.push_back(new std::string(""));
    text.push_back(new std::string(""));
    text.push_back(new std::string(_("Everyone else supporting this game...")));
    text.push_back(new std::string(_("... and playing it")));

    yoffset = yoffset_start;
    yoffset_end = -text.size() * text_height + 100;
}

Credits::~Credits()
{

}

void Credits::exec()
{
  bool escape, up, down;

    float t = 0;

    Timer::reset();

    draw();

    while (1) {

      SDL_Event event;
      while(SDL_PollEvent(&event)) {
	switch(event.type) {
	case SDL_KEYDOWN:
	  switch(event.key.keysym.sym) {
	  case SDLK_ESCAPE:
	    escape = true;
	    break;
	  case SDLK_UP:
	    up = true;
	    break;
	  case SDLK_DOWN:
	    down = true;
	    break;
	  }
	  break;
	case SDL_KEYUP:
	  switch(event.key.keysym.sym) {
	  case SDLK_ESCAPE:
	    escape = false;
	    break;
	  case SDLK_UP:
	    up = false;
	    break;
	  case SDLK_DOWN:
	    down = false;
	    break;
	  }
	  break;
	}
      }

        if (escape) {
	  for(std::list<GameObject*>::iterator iter = app->objects.begin();
	      iter != app->objects.end();
	      iter++) {
	    delete *iter;
	  }
	  app->objects.clear();
	  return;
        }
        if (up) {
	  speed = -SCROLL_SPEED;
        } else if (down) {
	  speed = SCROLL_SPEED;
        } else {
	  speed = normal_speed;
        }
	
        yoffset -= speed * Timer::time_elapsed(true);
        if (yoffset > yoffset_start) {
	  if (speed != 20 && !Config::get_kids_mode()) {
	    t += Timer::time_elapsed();
	    for (; t>0.04f; t-=0.04f) {
	      Corpse_Part* cp = new Corpse_Part( rand()%800-60, -40, app );
	      cp->fly_to( rand()%800-60, 540 );
	      PLAY_CENTER(Resources::Splash(rand()%2));
	    }
	  }
	  yoffset = yoffset_start;
	  speed = normal_speed;// = 20;

	  if (!stopped) {
	    PLAY_CENTER(Resources::Credits_stop());
	  }
	  stopped = true;
        } else if (yoffset < yoffset_end) {
	  if (speed != 40 && !Config::get_kids_mode()) {
	    t += Timer::time_elapsed();
	    for (; t>0.04f; t-=0.04f) {
	      Corpse_Part* cp = new Corpse_Part( rand()%800-60, -40, app );
	      cp->fly_to( rand()%800-60, 540 );
	      PLAY_CENTER(Resources::Splash(rand()%2));
	    }
	  }
	  yoffset = yoffset_end;

	  if (!stopped) {
	    PLAY_CENTER(Resources::Credits_stop());
	  }
	  stopped = true;
	} else {
	  stopped = false;
	}

        // Let them do their stuff
        //CL_Iterator<GameObject> object_counter(app->objects);
	for(std::list<GameObject*>::iterator object_iter = app->objects.begin();
	    object_iter != app->objects.end();
	    object_iter++) {
	  (*object_iter)->act();
        }
        // Check if we should delete some
	for(std::list<GameObject*>::iterator object_iter = app->objects.begin();
	    object_iter != app->objects.end();
	    object_iter++) {
	  if ((*object_iter)->delete_me) {
	    delete *object_iter;
	    object_iter = app->objects.erase(object_iter);
	  }
        }

        draw();
    }
}

void Credits::draw()
{
    CB_BlitSurface( Resources::Credits_horst_evil(), 0, 0);

    CB_BlitSurface( Resources::Game_cb_logo_small(), 10, yoffset+10);
    CB_BlitSurface( Resources::Game_cb_logo_small(), 640, yoffset+10);

    CB_BlitSurface( Resources::Intro_fl_logo(), 100, yoffset + text.size()*text_height + 130 );

    ///primary->SetColor( primary, 0xFF, 0xFF, 0xFF, 0xFF );

    //for (int i=0; i<text.get_num_items(); i++) {
    int i = 0;
    for(boost::ptr_list<std::string>::iterator text_iter = text.begin();
	text_iter != text.end();
	text_iter++) {
      CB_RenderTextCenter( Resources::Font_big(), *text_iter, 400, yoffset + i*40 + 60);//CENTER
      //CB_RenderTextCenter( Resources::Font_big(), *text_iter, 400, 50 + i*40 + 60);//CENTER
      i++;
    }

    if (yoffset < -10) {
      CB_RenderText( Resources::Font_big(), "+", 10, 9);//TOPLEFT
      CB_RenderTextRight( Resources::Font_big(), "+", 790, 9);//TOPRIGHT
    }

    if (yoffset > yoffset_end + 250) {
      CB_RenderText( Resources::Font_big(), "-", 10, 560);//TOPLEFT
      CB_RenderTextRight( Resources::Font_big(), "-", 790, 560);//TOPRIGHT
    }

    draw_objects();

    SDL_Flip(primary);
}

void Credits::draw_objects()
{
  //GameObject** draw_list;
  //draw_list = new GameObject*[app->objects.size()];
  std::vector<GameObject*>draw_list;

    //CL_Iterator<GameObject> object_counter(app->objects);
    for(std::list<GameObject*>::iterator object_iter = app->objects.begin();
	object_iter != app->objects.end();
	object_iter++) {
      draw_list.push_back(*object_iter);
    }

    //TODO sort using algorithm sort
    bool sort = true;
    GameObject* obj;
    while(sort && draw_list.size()) {
        sort = false;
        for(int i=0; i < (draw_list.size() - 1); i++ ) {
	  if (draw_list[i]->get_z() > draw_list[i+1]->get_z()) {
	    obj = draw_list[i];
	    draw_list[i] = draw_list[i+1];
	    draw_list[i+1] = obj;
	    sort = true;
	  }
        }
    }

    for(std::vector<GameObject*>::iterator draw_list_iter = draw_list.begin();
	draw_list_iter != draw_list.end();
	draw_list_iter++) {
      (*draw_list_iter)->show();
    }
}
