/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 1999-2004, 2007 Andreas Hundt, Denis Oliver Kropp
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <stdlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>

#include <config.h>

#include "SDL_rotozoom.h"

#include "Resources.h"
#include "ClanBomber.h"


#ifdef WORDS_BIGENDIAN
#define SWAP16(a) (((a)>>8) | ((a) << 8))
#define SWAP32(a) (((a) >> 24) | (((a) & 0x00ff0000) >>  8) | (((a) & 0x0000ff00) <<  8) | (((a) << 24)))
#endif

TTF_Font*		Resources::fnt_big = NULL;
TTF_Font*		Resources::fnt_small = NULL;

SDL_Surface*		Resources::sur_titlescreen = NULL;

SDL_Surface*		Resources::sur_fl_logo = NULL;
Mix_Chunk*	Resources::sfx_typewriter = NULL;
Mix_Chunk*	Resources::sfx_winlevel = NULL;

Resources::Surface*		Resources::sur_ps_teams = NULL;
Resources::Surface*		Resources::sur_ps_controls = NULL;
Resources::Surface*		Resources::sur_ps_teamlamps = NULL;
SDL_Surface*	Resources::sur_ps_background = NULL;

SDL_Surface*		Resources::sur_ls_background = NULL;
SDL_Surface*		Resources::sur_ls_not_available = NULL;

Resources::Surface*		Resources::sur_gs_tools = NULL;
Mix_Chunk*	Resources::sfx_klatsch = NULL;
SDL_Surface*		Resources::sur_gs_background = NULL;

Mix_Chunk*	Resources::sfx_forward = NULL;
Mix_Chunk*	Resources::sfx_rewind = NULL;
Mix_Chunk*	Resources::sfx_stop = NULL;

SDL_Surface*	Resources::sur_horst_evil = NULL;

Resources::Surface*	Resources::sur_bombers[NR_BOMBERSKINS] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };

Resources::Surface*	Resources::sur_extras = NULL;
Mix_Chunk*	Resources::sfx_wow = NULL;
Mix_Chunk*	Resources::sfx_joint = NULL;
Mix_Chunk*	Resources::sfx_horny = NULL;
Mix_Chunk*	Resources::sfx_schnief = NULL;

Mix_Chunk*	Resources::sfx_whoosh = NULL;
Mix_Chunk*	Resources::sfx_break = NULL;
Mix_Chunk*	Resources::sfx_clear = NULL;
Mix_Chunk*	Resources::sfx_menu_back = NULL;

Resources::Surface*	Resources::sur_observer = NULL;
Mix_Chunk*	Resources::sfx_hurry_up = NULL;
Mix_Chunk*	Resources::sfx_time_over = NULL;
Mix_Chunk*	Resources::sfx_crunch = NULL;

Mix_Chunk*	Resources::sfx_die = NULL;
Mix_Chunk*	Resources::sfx_explode = NULL;
Mix_Chunk*	Resources::sfx_putbomb = NULL;
Mix_Chunk*	Resources::sfx_deepfall = NULL;
Resources::Surface*	Resources::sur_maptiles = NULL;
Resources::Surface*	Resources::sur_maptile_addons = NULL;
Resources::Surface*	Resources::sur_bombs = NULL;
Resources::Surface*	Resources::sur_explosion = NULL;
SDL_Surface*	Resources::sur_cb_logo_small = NULL;

SDL_Surface*	Resources::sur_me_background = NULL;

Mix_Chunk*	Resources::sfx_corpse_explode = NULL;
Resources::Surface*	Resources::sur_corpse_part = NULL;

Mix_Chunk*	Resources::sfx_splash[2] = { NULL, NULL};


Resources::Resources()
{
}

Resources::~Resources()
{
}

void Resources::init()
{
}

TTF_Font* Resources::Font_big()
{
	if (!fnt_big) {
		fnt_big = TTF_OpenFont( DATADIR"/fonts/DejaVuSans-Bold.ttf", 28);
	}
	return fnt_big;
}

TTF_Font* Resources::Font_small()
{
	if (!fnt_small) {
		fnt_small = TTF_OpenFont( DATADIR"/fonts/DejaVuSans-Bold.ttf", 18);
	}
	return fnt_small;
}

SDL_Surface* Resources::Titlescreen()
{
	if (!sur_titlescreen) {
	  sur_titlescreen = IMG_Load(DATADIR"/pics/clanbomber_title_andi.png");
	}
	return sur_titlescreen;
}

SDL_Surface* Resources::Intro_fl_logo()
{
	if (!sur_fl_logo) {
		sur_fl_logo = IMG_Load(DATADIR"/pics/fischlustig_logo.png");
	}
	return sur_fl_logo;
}

Mix_Chunk* Resources::Intro_typewriter()
{
	if (!sfx_typewriter) {
		sfx_typewriter = Mix_LoadWAV(DATADIR"/wavs/typewriter.wav");
	}
	return sfx_typewriter;
}

Mix_Chunk* Resources::Intro_winlevel()
{
	if (!sfx_winlevel) {
		sfx_winlevel = Mix_LoadWAV(DATADIR"/wavs/winlevel.wav");
		///if (sfx_winlevel == NULL)
		///exit(1);
	}
	return sfx_winlevel;
}

Resources::Surface* Resources::Playersetup_teams()
{
	if (!sur_ps_teams) {
		sur_ps_teams = new Surface( DATADIR"/pics/ps_teams.png", 125, 56);
	}
	return sur_ps_teams;
}

Resources::Surface* Resources::Playersetup_controls()
{
	if (!sur_ps_controls) {
		sur_ps_controls = new Surface( DATADIR"/pics/ps_controls.png", 125, 56);
	}
	return sur_ps_controls;
}

Resources::Surface* Resources::Playersetup_teamlamps()
{
	if (!sur_ps_teamlamps) {
		sur_ps_teamlamps = new Surface( DATADIR"/pics/ps_teamlamps.png", 30, 32);
	}
	return sur_ps_teamlamps;
}

SDL_Surface* Resources::Playersetup_background()
{
	if (!sur_ps_background) {
		sur_ps_background = IMG_Load(DATADIR"/pics/playersetup.png");
	}
	return sur_ps_background;
}

SDL_Surface* Resources::Mapselector_background()
{
	if (!sur_ls_background) {
		sur_ls_background = IMG_Load(DATADIR"/pics/level_selection.png");
	}
	return sur_ls_background;
}

SDL_Surface* Resources::Mapselector_not_available()
{
	if (!sur_ls_not_available) {
		sur_ls_not_available = IMG_Load(DATADIR"/pics/not_available.png");
	}
	return sur_ls_not_available;
}

Resources::Surface* Resources::Gamestatus_tools()
{
	if (!sur_gs_tools) {
		sur_gs_tools = new Surface( DATADIR"/pics/cup2.png", 40, 40);
	}
	return sur_gs_tools;
}

Mix_Chunk* Resources::Gamestatus_klatsch()
{
	if (!sfx_klatsch) {
		sfx_klatsch = Mix_LoadWAV( DATADIR"/wavs/klatsch.wav");
	}
	return sfx_klatsch;
}

SDL_Surface* Resources::Gamestatus_background()
{
	if (!sur_gs_background) {
		sur_gs_background = IMG_Load( DATADIR"/pics/game_status.png" );
	}
	return sur_gs_background;
}

Mix_Chunk* Resources::Credits_forward()
{
	if (!sfx_forward) {
		sfx_forward = Mix_LoadWAV( DATADIR"/wavs/forward.wav");
	}
	return sfx_forward;
}

Mix_Chunk* Resources::Credits_rewind()
{
	if (!sfx_rewind) {
		sfx_rewind = Mix_LoadWAV( DATADIR"/wavs/rewind.wav");
	}
	return sfx_rewind;
}

Mix_Chunk* Resources::Credits_stop()
{
	if (!sfx_stop) {
		sfx_stop = Mix_LoadWAV( DATADIR"/wavs/stop.wav");
	}
	return sfx_stop;
}


SDL_Surface* Resources::Credits_horst_evil()
{
	if (!sur_horst_evil) {
		sur_horst_evil = IMG_Load( DATADIR"/pics/horst_evil.png" );
	}
	return sur_horst_evil;
}

Resources::Surface* Resources::Bombers(int nr)
{
	if (nr >= NR_BOMBERSKINS || nr < 0) {
		return NULL;
	}
	if (!sur_bombers[nr]) {
		sur_bombers[0] = new Surface( DATADIR"/pics/bomber_snake.png", 40, 60);
		sur_bombers[1] = new Surface( DATADIR"/pics/bomber_tux.png", 40, 60);
		sur_bombers[2] = new Surface( DATADIR"/pics/bomber_spider.png", 40, 40);
		sur_bombers[3] = new Surface( DATADIR"/pics/bomber_bsd.png", 40, 60);
		sur_bombers[4] = new Surface( DATADIR"/pics/bomber_dull_red.png", 40, 40);
		sur_bombers[5] = new Surface( DATADIR"/pics/bomber_dull_blue.png", 40, 40);
		sur_bombers[6] = new Surface( DATADIR"/pics/bomber_dull_yellow.png", 40, 40);
		sur_bombers[7] = new Surface( DATADIR"/pics/bomber_dull_green.png", 40, 40);
	//	sur_bombers[8] = new Surface( DATADIR"/pics/bomber_black.png", 40, 40, 0x00FF00FF );
	}
	return sur_bombers[nr];
}

Resources::Surface* Resources::Extras_extras()
{
	if (!sur_extras) {
		sur_extras = new Surface( DATADIR"/pics/extras2.png", 40, 40 );
	}
	return sur_extras;
}

Mix_Chunk* Resources::Extras_wow()
{
	if (!sfx_wow) {
		sfx_wow = Mix_LoadWAV( DATADIR"/wavs/wow.wav");
	}
	return sfx_wow;
}

Mix_Chunk* Resources::Extras_joint()
{
	if (!sfx_joint) {
		sfx_joint = Mix_LoadWAV(DATADIR"/wavs/joint.wav");
	}
	return sfx_joint;
}

Mix_Chunk* Resources::Extras_horny()
{
	if (!sfx_horny) {
		sfx_horny = Mix_LoadWAV(DATADIR"/wavs/horny.wav");
	}
	return sfx_horny;
}

Mix_Chunk* Resources::Extras_schnief()
{
	if (!sfx_schnief) {
		sfx_schnief = Mix_LoadWAV(DATADIR"/wavs/schnief.wav");
	}
	return sfx_schnief;
}

Mix_Chunk* Resources::Menu_whoosh()
{
	if (!sfx_whoosh) {
		sfx_whoosh = Mix_LoadWAV(DATADIR"/wavs/whoosh.wav");
	}
	return sfx_whoosh;
}

Mix_Chunk* Resources::Menu_break()
{
	if (!sfx_break) {
		sfx_break = Mix_LoadWAV(DATADIR"/wavs/break.wav");
	}
	return sfx_break;
}

Mix_Chunk* Resources::Menu_clear()
{
	if (!sfx_clear) {
		sfx_clear = Mix_LoadWAV(DATADIR"/wavs/clear.wav");
	}
	return sfx_clear;
}
	
Mix_Chunk* Resources::Menu_back()
{
	if (!sfx_menu_back) {
		sfx_menu_back = Mix_LoadWAV(DATADIR"/wavs/menu_back.wav");
	}
	return sfx_menu_back;
}
	
Resources::Surface* Resources::Observer_observer()
{
	if (!sur_observer) {
   		sur_observer = new Surface( DATADIR"/pics/observer.png", 40, 40);
	}
	return sur_observer;
}

Mix_Chunk* Resources::Observer_hurry_up()
{
	if (!sfx_hurry_up) {
		sfx_hurry_up = Mix_LoadWAV(DATADIR"/wavs/hurry_up.wav");
	}
	return sfx_hurry_up;
}

Mix_Chunk* Resources::Observer_time_over()
{
	if (!sfx_time_over) {
		sfx_time_over = Mix_LoadWAV(DATADIR"/wavs/time_over.wav");
	}
	return sfx_time_over;
}

Mix_Chunk* Resources::Observer_crunch()
{
	if (!sfx_crunch) {
		sfx_crunch = Mix_LoadWAV(DATADIR"/wavs/crunch.wav");
	}
	return sfx_crunch;
}

Mix_Chunk* Resources::Game_die()
{
	if (!sfx_die) {
		sfx_die = Mix_LoadWAV(DATADIR"/wavs/die.wav");
	}
	return sfx_die;
}

Mix_Chunk* Resources::Game_explode()
{
	if (!sfx_explode) {
		sfx_explode = Mix_LoadWAV(DATADIR"/wavs/explode.wav");
	}
	return sfx_explode;
}

Mix_Chunk* Resources::Game_putbomb()
{
	if (!sfx_putbomb) {
		sfx_putbomb = Mix_LoadWAV(DATADIR"/wavs/putbomb.wav");
	}
	return sfx_putbomb;
}

Mix_Chunk* Resources::Game_deepfall()
{
	if (!sfx_deepfall) {
		sfx_deepfall = Mix_LoadWAV(DATADIR"/wavs/deepfall.wav");
	}
	return sfx_deepfall;
}

Resources::Surface* Resources::Game_maptiles()
{
	if (!sur_maptiles) {
		sur_maptiles = new Surface( DATADIR"/pics/maptiles.png", 40, 40 );
	}
	return sur_maptiles;
}

Resources::Surface* Resources::Game_maptile_addons()
{
	if (!sur_maptile_addons) {
		sur_maptile_addons = new Surface( DATADIR"/pics/maptile_addons.png", 40, 40);
	}
	return sur_maptile_addons;
}

Resources::Surface* Resources::Game_bombs()
{
	if (!sur_bombs) {
		sur_bombs = new Surface( DATADIR"/pics/bombs.png", 40, 40);
	}
	return sur_bombs;
}

Resources::Surface* Resources::Game_explosion()
{
	if (!sur_explosion) {
		sur_explosion = new Surface( DATADIR"/pics/explosion2.png", 40, 40);
	}
	return sur_explosion;
}

SDL_Surface* Resources::Game_cb_logo_small()
{
	if (!sur_cb_logo_small) {
		sur_cb_logo_small = IMG_Load(DATADIR"/pics/cb_logo_small.png");
	}
	return sur_cb_logo_small;
}
	
SDL_Surface* Resources::MapEditor_background()
{
	if (!sur_me_background) {
		sur_me_background = IMG_Load(DATADIR"/pics/map_editor.png");
	}
	return sur_me_background;
}

Mix_Chunk* Resources::Corpse_explode()
{
	if (!sfx_corpse_explode) {
		sfx_corpse_explode = Mix_LoadWAV(DATADIR"/wavs/corpse_explode.wav");
	}
	return sfx_corpse_explode;
}

Resources::Surface* Resources::Corpse_part()
{
	if (!sur_corpse_part) {
		sur_corpse_part = new Surface( DATADIR"/pics/corpse_parts.png", 40, 40);
	}
	return sur_corpse_part;
}

Mix_Chunk* Resources::Splash(int nr)
{
	if (nr > 1 || nr < 0) {
		return NULL;
	}
	if (!sfx_splash[nr]) {
		sfx_splash[0] = Mix_LoadWAV(DATADIR"/wavs/splash1a.wav");
		sfx_splash[1] = Mix_LoadWAV(DATADIR"/wavs/splash2a.wav");
	}
	return sfx_splash[nr];
}

Resources::Surface::Surface( const char *filename, int sprite_width, int sprite_height )
{
	surface = IMG_Load(filename);
	
	frames_per_row = surface->w/sprite_width;
	
	this->sprite_width = sprite_width;
	this->sprite_height = sprite_height;
}

Resources::Surface::~Surface()
{
	SDL_FreeSurface(surface);
}

int Resources::Surface::get_height()
{
	return sprite_height;
}

void Resources::Surface::put_screen( int x, int y, int frame, Uint8 opacity )
{
	SDL_Rect srect;
	SDL_Rect drect;
	
	srect.x = (frame % frames_per_row) * sprite_width;
	srect.y = (frame / frames_per_row) * sprite_height;
	srect.w = sprite_width;
	srect.h = sprite_height;

	drect.x = x;
	drect.y = y;
	
	if (opacity < 255) {
	         ///primary->SetColor( primary, 0, 0, 0, opacity );
	  SDL_BlitSurface(surface, &srect, primary, &drect);
	  //TODO add opacity, where is used?
	}

	SDL_BlitSurface(surface, &srect, primary, &drect);
}

void Resources::Surface::put_screen( int x, int y, float scale_x, float scale_y, int frame, Uint8 opacity )
{
        /**dr.x = x;
	dr.y = y;
	dr.w = (int)(scale_x * sprite_width + 0.5f);
	dr.h = (int)(scale_y * sprite_height + 0.5f);**/
	
        ///primary->StretchBlit( primary, surface, &sr, &dr );

  //This function needs cleanup
	SDL_Rect srect;
	SDL_Rect irect;
	SDL_Rect drect;
	SDL_Surface *tmpSurface;
	SDL_Surface *surf;
	
	srect.x = (frame % frames_per_row) * sprite_width;
	srect.y = (frame / frames_per_row) * sprite_height;
	srect.w = sprite_width;
	srect.h = sprite_height;

	irect.x = 0;
	irect.y = 0;

	drect.x = x;
	drect.y = y;

	tmpSurface = SDL_CreateRGBSurface(SDL_SWSURFACE, srect.w, srect.h, 32, 0, 0, 0, 0);

	Uint8 r, g, b;
	SDL_GetRGB(surface->format->colorkey, surface->format, &r, &g, &b);
	SDL_SetColorKey(tmpSurface, SDL_SRCCOLORKEY, SDL_MapRGB(tmpSurface->format, r, g, b));
	SDL_FillRect(tmpSurface, NULL, SDL_MapRGB(tmpSurface->format, r, g, b) );
	SDL_BlitSurface(surface, &srect, tmpSurface, &irect);

	surf = zoomSurface(tmpSurface, scale_x, scale_y, 0);
	
	SDL_SetColorKey(surf, SDL_SRCCOLORKEY, SDL_MapRGB(surf->format, r, g, b));
	
	srect.x = 0;
	srect.y = 0;
	srect.w = surf->w;
	srect.h = surf->h;

	if (opacity < 255) {
	         ///primary->SetColor( primary, 0, 0, 0, opacity );
	SDL_BlitSurface(surf, &srect, primary, &drect);
	  //TODO add opacity, where is used?
	}

	SDL_BlitSurface(surf, &srect, primary, &drect);

	SDL_FreeSurface(tmpSurface);
	SDL_FreeSurface(surf);
}

void Resources::Surface::get_rect( int frame, SDL_Rect *ret_rect )
{
     ret_rect->x = (frame % frames_per_row) * sprite_width;
     ret_rect->y = (frame / frames_per_row) * sprite_height;
     ret_rect->w = sprite_width;
     ret_rect->h = sprite_height;
}
