/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 1999-2004, 2007 Andreas Hundt, Denis Oliver Kropp
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */


#ifndef RESOURCES_H
#define RESOURCES_H

///#include <directfb.h>
#include "SDL.h"
#include "SDL_ttf.h"
#include "SDL_image.h"
///#include "SDL_gfx.h"
///#include <fusionsound.h>
#include "SDL_mixer.h"

#define NR_BOMBERSKINS 8

/**
  *@author Andreas Hundt, Denis Oliver Kropp
  */

class Resources
{
public:
	Resources();
	~Resources();
	
	class Surface
	{
	public:
		Surface( const char *filename, int sprite_width, int sprite_height );
		~Surface();
		
		int get_height();
		
		void put_screen( int x, int y, int frame, Uint8 opacity = 255 );
		void put_screen( int x, int y, float scale_x, float scale_y, int frame, Uint8 opacity = 255 );
	
        void get_rect( int frame, SDL_Rect *ret_rect );
	
		SDL_Surface *surface;

    private:
		int sprite_width;
		int sprite_height;
		int frames_per_row;
	};

	static void init();

	static TTF_Font*		Font_big();
	static TTF_Font*		Font_small();

	static SDL_Surface*		Titlescreen();

	static SDL_Surface*		Intro_fl_logo();
	static Mix_Chunk*	Intro_typewriter();
	static Mix_Chunk*	Intro_winlevel();

	static Surface*		Playersetup_teams();
	static Surface*		Playersetup_controls();
	static Surface*		Playersetup_teamlamps();
	static SDL_Surface*		Playersetup_background();

	static SDL_Surface*		Mapselector_background();
	static SDL_Surface*		Mapselector_not_available();
	
	static Surface*		Gamestatus_tools();
	static Mix_Chunk*	Gamestatus_klatsch();
	static SDL_Surface* Gamestatus_background();

	static Mix_Chunk*	Credits_forward();
	static Mix_Chunk*	Credits_rewind();
	static Mix_Chunk*	Credits_stop();


	static SDL_Surface*		Credits_horst_evil();
	
	static Surface*			Bombers(int nr);

	static Surface*			Extras_extras();
	static Mix_Chunk*	Extras_wow();
	static Mix_Chunk*	Extras_joint();
	static Mix_Chunk*	Extras_horny();
	static Mix_Chunk*	Extras_schnief();

	static Mix_Chunk*	Menu_whoosh();
	static Mix_Chunk*	Menu_break();
	static Mix_Chunk*	Menu_clear();
	static Mix_Chunk*	Menu_back();
	
	static Surface*				Observer_observer();
	static Mix_Chunk*	Observer_hurry_up();
	static Mix_Chunk*	Observer_time_over();
	static Mix_Chunk*	Observer_crunch();

	static Mix_Chunk*	Game_die();
	static Mix_Chunk*	Game_explode();
	static Mix_Chunk*	Game_putbomb();
	static Mix_Chunk*	Game_deepfall();
	static Surface*		Game_maptiles();
	static Surface*		Game_maptile_addons();
	static Surface*		Game_bombs();
	static Surface*		Game_explosion();
	static SDL_Surface*		Game_cb_logo_small();
	
	static SDL_Surface*		MapEditor_background();

	static Mix_Chunk*	Corpse_explode();
	static Surface*		Corpse_part();
	
	static Mix_Chunk*	Splash(int nr);

protected:	

	static TTF_Font *fnt_big;
	static TTF_Font *fnt_small;

	static SDL_Surface *sur_titlescreen;
	
	static SDL_Surface *sur_fl_logo;
	static Mix_Chunk *sfx_typewriter;
	static Mix_Chunk *sfx_winlevel;
	
	static Surface *sur_ps_teams;
	static Surface *sur_ps_controls;
	static Surface *sur_ps_teamlamps;
	static SDL_Surface *sur_ps_background;
	
	static SDL_Surface *sur_ls_background;
	static SDL_Surface *sur_ls_not_available;
	
	static Surface *sur_gs_tools;
	static Mix_Chunk *sfx_klatsch;
	static SDL_Surface *sur_gs_background;
	
	static Mix_Chunk *sfx_forward;
	static Mix_Chunk *sfx_rewind;
	static Mix_Chunk *sfx_stop;

	static SDL_Surface		*sur_horst_evil;
	
	static Surface			*sur_bombers[NR_BOMBERSKINS];
	
	static Surface			*sur_extras;
	static Mix_Chunk *sfx_wow;
	static Mix_Chunk *sfx_joint;
	static Mix_Chunk *sfx_horny;
	static Mix_Chunk *sfx_schnief;
	
	static Mix_Chunk *sfx_whoosh;
	static Mix_Chunk *sfx_break;
	static Mix_Chunk *sfx_clear;
	static Mix_Chunk *sfx_menu_back;
	
	static Surface *sur_observer;
	static Mix_Chunk *sfx_hurry_up;
	static Mix_Chunk *sfx_time_over;
	static Mix_Chunk *sfx_crunch;
	
	static Mix_Chunk *sfx_die;
	static Mix_Chunk *sfx_explode;
	static Mix_Chunk *sfx_putbomb;
	static Mix_Chunk *sfx_deepfall;
	static Surface		 *sur_maptiles;
	static Surface		 *sur_maptile_addons;
	static Surface		 *sur_bombs;
	static Surface		*sur_explosion;
	static SDL_Surface *sur_cb_logo_small;

	static SDL_Surface *sur_me_background;

	static Mix_Chunk *sfx_corpse_explode;
	static Surface *sur_corpse_part;
	
	static Mix_Chunk *sfx_splash[2];
};

#endif
