/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "UtilsSocket.h"
#include <cstdio>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
//#include <netinet/tcp.h>
#include <arpa/inet.h>


sockaddr_in CB_Socket::createSocketAddr_in(const char* ip_address, unsigned int port)
{
  sockaddr_in server_sai;
  server_sai.sin_family = AF_INET;
  server_sai.sin_port = htons(port);
  //server_sai.sin_addr.s_addr = inet_addr(ip_address);
  if (!inet_aton(ip_address, &server_sai.sin_addr)) {
    //throw exception
    printf("Error creating socket\n");
  }
  return server_sai;
}

sockaddr_in CB_Socket::createSocketAddr_in(uint32_t ip_address, unsigned int port)
{
  in_addr addr;
  addr.s_addr = ip_address;
  return createSocketAddr_in(inet_ntoa(addr), port);
}

sockaddr_in CB_Socket::createSocketAddr_in(hostent *server_hostent, unsigned int port)
{
  sockaddr_in server_sai;
  server_sai.sin_family = AF_INET;
  server_sai.sin_port = htons(port);
  server_sai.sin_addr = *((in_addr*) server_hostent->h_addr_list[0]);
  return server_sai;
}

hostent *CB_Socket::resolveHost(const char *server_name)
{
  hostent *server_hostent;
  server_hostent = gethostbyname(server_name);
  return server_hostent;
}

void CB_Socket::closeSocket(int socket_fd)
{
  shutdown(socket_fd, SHUT_RDWR);
  close(socket_fd);
}

void CB_Socket::bindSocket(int socket_fd, unsigned int client_port)
{
  sockaddr_in local_sai;
  local_sai.sin_family = AF_INET;
  local_sai.sin_port = htons(client_port);
  local_sai.sin_addr.s_addr = htonl(INADDR_ANY);

  int bind_failed = bind(socket_fd, (sockaddr*) &local_sai, sizeof(sockaddr_in));
  
  if (bind_failed) {
    printf("Bind cannot be established\n");
  }
}
