/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef UTILSSOCKET_H
#define UTILSSOCKET_H


#include <netinet/in.h>
#include <netdb.h>


/**
 * Base for all classes used for network access.
 * This provides all methods common to all network access both TCP or UDP.
 * The methods do not access or modify any variable outside them.
 * <p/>
 * This should not be instantiated, just derived.
 * <p/>
 * All non public methods of this class an subclasses are implementation
 * dependant.
 * @author rsl
 */
class CB_Socket
{
 public:

 protected:
  /**
   * Creates a socketaddr_in from an IP address and a port.
   * Use when you have an IP address as text.
   * @param ip_address IP address of the other point.
   * @param port Port number of the other point.
   * @return sockaddr_in using AF_INET, ip_address and port.
   */
  sockaddr_in createSocketAddr_in(const char* ip_address, unsigned int port);
  /**
   * Creates a socketaddr_in from an IP address and a port.
   * Use when you have an IP address as uint32_t (only ipv4).
   * @param ip_address IP address in numeric form and network order.
   * @param port Port number.
   * @return sockaddr_in using AF_INET, ip_address and port.
   */
  sockaddr_in createSocketAddr_in(uint32_t ip_address, unsigned int port);
  /**
   * Creates a socketaddr_in from a hostent and a port.
   * Use with hostent provided with resolveHost.
   * @param server_hostent hostent with data of the othe point.
   * @param port Port number of the other point. 
   */
  sockaddr_in createSocketAddr_in(hostent *server_hostent, unsigned int port);
  /**
   * Resolves a host and put it info in a hostent.
   * 
   * @param server_name  Hostname (FQDN)
   * @return A pointer to hostent with its data filled.
   */
  hostent *resolveHost(const char *server_name);
  //void connectSocket(int socket_fd, sockaddr_in *server);
  //int openSocket();
  /**
   * Closes a socket.
   * 
   * @param socket_fs A socket file descriptor.
   */
  void closeSocket(int socket_fd);
  /**
   * Binds a socket to a port.
   * The socket listen in all its address.
   * @param socket_fd A socket file descriptor, where bind will be applied.
   * @param client_port Port to listen
   */
  void bindSocket(int socket_fd, unsigned int client_port);
 private:

};

#endif
