/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "UtilsSocketAddress.h"
#include <arpa/inet.h>

#include <stdio.h>

namespace CB
{
  SocketAddress::SocketAddress()
  {
    address.s_addr = 0;
    port = 0;
  }

  SocketAddress::SocketAddress(const char* ip_address, uint16_t port)
  {
    //TODO error check
    inet_pton(AF_INET, ip_address, &address);
    this->port = port;
  }

  uint32_t SocketAddress::getAddress()
  {
    return address.s_addr;
  }

  uint16_t SocketAddress::getPort()
  {
    return port;
  }

  const char* SocketAddress::getStringAddress()
  {
    //TODO isn't better to return a dynamic object
    static char ip_address[INET6_ADDRSTRLEN];
    inet_ntop(AF_INET,
	      &address,
	      ip_address,
	      INET6_ADDRSTRLEN);
    return ip_address;
  }
}
