/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef UTILSSOCKETADDRESS_H
#define UTILSSOCKETADDRESS_H
//this one requires support for C++0x (use -std=c++0x or -std=gnu++0x)
//#include <cstdint>
#include <stdint.h>

//#include <string>
#include <arpa/inet.h>

namespace CB
{
  /**
   *
   * @author rsl
   * @todo Add port info or change name
   */
  class SocketAddress
  {
  public:
    SocketAddress();
    SocketAddress(const char* ip_address, uint16_t port);
    uint32_t getAddress();
    uint16_t getPort();
    //char* getAddress();
    const char* getStringAddress();
    const char* getHostname() {return "HN";}
  private:
    in_addr address;
    uint16_t port;
    //std::string hostname;
  };
}

#endif
