/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "UtilsSocketTCP.h"
#include <cstdio>
#include <unistd.h>
#include <netdb.h>


void CB_SocketTCP::connectSocket(int socket_fd, sockaddr_in *server)
{
  int socket_failed = connect(socket_fd, (sockaddr*) server, sizeof(sockaddr_in));
  
  if (socket_failed) {
    printf("Connection cannot be established\n");
  }
}

int CB_SocketTCP::openSocket()
{
  int socket_fd;
  //TODO Check if IPPROTO_IP is required
  socket_fd = socket(AF_INET, SOCK_STREAM, IPPROTO_IP);
  //socket_fd = socket(AF_INET, SOCK_STREAM, 0);
  
  //TODO Check if these options are really necesary
  int option_value = 1; 
  setsockopt(socket_fd, SOL_SOCKET, SO_REUSEADDR, &option_value, sizeof(int));
  setsockopt(socket_fd, IPPROTO_TCP, TCP_NODELAY, &option_value, sizeof(int));

  //printf("Socket creation failed\n");
  return socket_fd;
}
