/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef UTILSSOCKETTCP_H
#define UTILSSOCKETTCP_H
#include "UtilsSocket.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>


/**
 * Base class used for all TCP network access.
 * Provides all methods requiered for use in a server or client TCP Socket.
 * @author rsl
 */
class CB_SocketTCP : public CB_Socket
{
 protected:
  /**
   * Connect a socket to a host.
   * 
   * @param socket_fd A socket file descriptor.
   * @param server Where to connect.
   */
  void connectSocket(int socket_fd, sockaddr_in *server);
  /**
   * Open a socket.
   * 
   * @return A socket file descriptor.
   */
  int openSocket();
};

#endif
