/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "UtilsSocketTCPClient.h"
#include <cstdio>
#include <unistd.h>
#include <netdb.h>


CB_SocketTCPClient::CB_SocketTCPClient(const char* server, unsigned int port)
{
  printf("The server is: %s", server);
  hostent *server_hostent  = resolveHost(server);
  sockaddr_in server_sai;
  if (server_hostent == NULL) {
    server_sai = createSocketAddr_in(server, port);
  } else {
    server_sai = createSocketAddr_in(server_hostent, port);
  }
  socketfd = openSocket();
  connectSocket(socketfd, &server_sai);
}

CB_SocketTCPClient::CB_SocketTCPClient(int socket_fd)
{
  socketfd = socket_fd;
}

CB_SocketTCPClient::~CB_SocketTCPClient()
{
  closeSocket(socketfd);
}

int CB_SocketTCPClient::getPeerName(sockaddr* sa, socklen_t* len)
{
  return getpeername(socketfd, sa, len);
}
