/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef UTILSSOCKETTCPCLIENT_H
#define UTILSSOCKETTCPCLIENT_H
#include "UtilsSocketTCP.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>


/**
 * For a TCP client (access) connection.
 *
 * @author rsl
 */
class CB_SocketTCPClient : public CB_SocketTCP
{
 public:
  /**
   * Temporal variable used, just for compatibility
   * @todo REMOVE
   */
  sockaddr_in removeMe;
  /**
   * Temporal Method used, just for compatibility
   * @todo REMOVE
   */
  int getPeerName(sockaddr* sa, socklen_t* len);
  /**
   * Connects to a server in a specified port.
   * 
   * @param server Server hostname.
   * @param port Server port.
   */
  CB_SocketTCPClient(const char* server, unsigned int port);
  /**
   * Wraps a stablished socket.
   * Used from {@link CB_SocketTCPServer}
   * @param socket_fs A socket file descriptor.
   */
  CB_SocketTCPClient(int socket_fd);
  /**
   * Closes the socket.
   *
   */
  ~CB_SocketTCPClient();
 private:
  int socketfd;
};

#endif
