/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "UtilsSocketTCPServer.h"
#include <cstdio>
#include <sys/socket.h>


CB_SocketTCPServer::CB_SocketTCPServer(unsigned int port, int max_connections)
{
  socketfd = openSocket();
  bindSocket(socketfd, port);
  setMaxClients(socketfd, max_connections);
}

CB_SocketTCPServer::~CB_SocketTCPServer()
{
  closeSocket(socketfd);
}

void CB_SocketTCPServer::setMaxClients(int socket_fd, int max_connections)
{
  listen(socket_fd, max_connections);
}

CB_SocketTCPClient *CB_SocketTCPServer::accept()
{
  //sockaddr client;
  //socklen_t client_length = sizeof(sockaddr);
  //int new_socket = ::accept(socketfd, &client, &client_length);
  int new_socket = ::accept(socketfd, NULL, NULL);
  if (new_socket < 0) {
    printf("Error accepting connection");
    return NULL;
  }
  return new CB_SocketTCPClient(new_socket);
}
