/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef UTILSSOCKETTCPSERVER_H
#define UTILSSOCKETTCPSERVER_H
#include "UtilsSocketTCP.h"
#include "UtilsSocketTCPClient.h"


/**
 * For a TCP server (listen) connection.
 *
 * @author rsl
 */
class CB_SocketTCPServer : public CB_SocketTCP
{
 public:
  /**
   * Listen in a port and a maximum number of connection specified.
   *
   * @param port Listen port.
   * @param max_connections Maximum number of connections
   */
  CB_SocketTCPServer(unsigned int port, int max_connections);
  /**
   * Closes the socket.
   *
   */
  ~CB_SocketTCPServer();
  /**
   * Accepts an incomming connection.
   * Used to accept an incomming connection and stablishes a new socket for it.
   * @return A CB_SocketTCPClient already connected.
   */
  CB_SocketTCPClient *accept();
 private:
  /**
   * Sets the maximum number of  connections to a socket.
   *
   * @param socket_fd A socket file descriptor.
   * @param max_connections Maximun number of connections to be accepted.
   */
  void setMaxClients(int socket_fd, int max_connections);

  int socketfd;
};

#endif
