/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include "UtilsSocketUDP.h"
#include <cstdio>
#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>
//#include <netinet/tcp.h>
#include <arpa/inet.h>



CB_SocketUDP::CB_SocketUDP(const char* server, unsigned int port, unsigned int client_port)
{
  printf("\nThe UDP params are server: %s - port: %u - client_port: %u\n", server, port, client_port);
  hostent *server_hostent  = resolveHost(server);
  if (server_hostent == NULL) {
    server_sai = createSocketAddr_in(server, port);
  } else {
    server_sai = createSocketAddr_in(server_hostent, port);
  }
  socketfd = openSocket();
  bindSocket(socketfd, client_port);
}

CB_SocketUDP::CB_SocketUDP(unsigned int port)
{
  socketfd = openSocket();
  bindSocket(socketfd, port);
}

CB_SocketUDP::~CB_SocketUDP()
{
  closeSocket(socketfd);
}

int CB_SocketUDP::openSocket()
{
  int socket_fd;
  //TODO Check if IPPROTO_IP is required
  socket_fd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  //socket_fd = socket(AF_INET, SOCK_STREAM, 0);
  
  //TODO Check if this option is really necesary
  int option_value = 1; 
  setsockopt(socket_fd, SOL_SOCKET, SO_REUSEADDR, &option_value, sizeof(int));

  //printf("Socket creation failed\n");
  return socket_fd;
}

int CB_SocketUDP::recv(void *buffer, size_t length)
{
  int server_sai_size = sizeof(sockaddr_in);
  int bytes_received = recvfrom(socketfd, buffer, length, 0, (sockaddr*) &server_sai, (socklen_t*) &server_sai_size);
  //TODO error checking
  return bytes_received;
}

void CB_SocketUDP::receive(CB::UDPPacket *packet)
{
  sockaddr_in remote_sai;
  int remote_sai_size = sizeof(sockaddr_in);
  if (sizeof(sockaddr_in) != sizeof(remote_sai)) {
    printf("Error: all sizeof must use instance not type\n");
  }
  int bytes_received = recvfrom(socketfd, packet->getData(), packet->getLength(), 0, (sockaddr*) &remote_sai, (socklen_t*) &remote_sai_size);
  packet->setLength(bytes_received);
  char ip_address[INET6_ADDRSTRLEN]; 
  CB::SocketAddress sa(inet_ntop(remote_sai.sin_family,
				 &remote_sai.sin_addr,
				 ip_address,
				 INET6_ADDRSTRLEN),
		       remote_sai.sin_port);
  packet->setAddress(sa);
  //TODO error checking
}

int CB_SocketUDP::send(void *message, size_t length)
{
  int bytes_sent = sendto(socketfd, message, length, 0, (sockaddr*) &server_sai, sizeof(sockaddr_in));
  //TODO error checking
  return bytes_sent;
}

void CB_SocketUDP::send(CB::UDPPacket &packet)
{
  sockaddr_in remote = createSocketAddr_in(packet.getAddress().getAddress(), packet.getAddress().getPort());
  int bytes_sent = sendto(socketfd, packet.getData(), packet.getLength(), 0, (sockaddr*) &remote, sizeof(sockaddr_in));
  packet.setLength(bytes_sent);
  //TODO error checking
}
