/*
 * This file is part of ClanBomber;
 * you can get it at "http://www.nongnu.org/clanbomber".
 *
 * Copyright (C) 2009 Rene Lopez <rsl@members.fsf.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef UTILSSOCKETUDP_H
#define UTILSSOCKETUDP_H
#include "UtilsSocket.h"
//#include <cstdlib>
#include "UtilsUDPPacket.h"

#include <netinet/in.h>
#include <netdb.h>


/**
 * For UDP network access.
 * Is used for servers and clients alike.
 * @todo document this right
 * @author rsl
 */
class CB_SocketUDP : public CB_Socket
{
 public:
  /**
   * Creates a UDP socket from 
   */
  CB_SocketUDP(const char* server, unsigned int port, unsigned int client_port);
  /**
   * Creates a UDP socket which will listen on port.
   * @param port Port to bind socket.
   */
  CB_SocketUDP(unsigned int port);
  ~CB_SocketUDP();
  /**
   * Receive data.
   * Receive data and store it in a buffer.
   * @param buffer Buffer to store data.
   * @param length Size in bytes of buffer, maximum number of data to store on 
   *               buffer.
   * @return Number of bytes written in buffer, or -1 for error.
   * @deprecated
   */
  int recv(void *buffer, size_t length);
  /**
   * Receive data.
   * Receive data and store it in a UDPPacket.
   * @param packet An UDPPacket where received info will be stored.
   */
  void receive(CB::UDPPacket *packet);
  /**
   * Send data.
   * Send data from a parameter.
   * @param message Data to be sent.
   * @param length Size in bytes of message, maximum number of data to send.
   * @todo Check if send return -1 on error.
   * @return Number of bytes sent, or -1 for error.
   * @deprecated
   */
  int send(void *message, size_t length);
  /**
   * Send data.
   * Send data from a UDPPacket. At return data sent will be stored in packet as
   * as length (packet.getLength()).
   * @param packet An UDPPacket.
   * @todo Check if send return -1 on error.
   */
  void send(CB::UDPPacket &packet);
 private:
  int openSocket();

  int socketfd;
  sockaddr_in server_sai;
};

#endif
