#!/bin/bash

# This file is part of Clusterix, Copyright (C) 2004 Alessandro Manzini, 
# email: a.manzini@infogroup.it

# Clusterix is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Clusterix is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Clusterix; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

# Version 0.9
# .Modified start sequence to not permit prolification if start process
# . Send an email alert if the service dont start correctly
# . all parameters are now put in the conf file
# . changed grep string to permit better start and stop control
# . added time in sec before to begin to check process after the start
#   of service.
# . added second stop script

servicename="$1"
log="$2"
start_service_comand="$3"
stop_service_comand="$4"
includestringstart="$5"
excludestringstart="$6"
includestringstop="$7"
excludestringstop="${8}"
timeoutstop="${9}"
timeoutstart="${10}"
ps="${11}"
psoption="${12}"
mailto="${13}"
iam="${14}"
countstartlimit="${15}"
countstart="${16}"
begincheck="${17}"
stop_service_comand_2="${18}"
timeoutstop_2="${19}"

findpidstop() {
if [ ! -z "$excludestringstop" ]
then
if [ ! -z "$includestringstop" ];then pid="$("$ps" "$psoption" | grep -E "$includestringstop" | grep -vE "$excludestringstop" | grep -v grep | grep -v "$stop_service_comand" | awk '{print $2}')"; fi
else
if [ ! -z "$includestringstop" ];then pid="$("$ps" "$psoption" | grep -E "$includestringstop" |  grep -v grep | grep -v "$stop_service_comand" | awk '{print $2}')"; fi
fi
}

teststart() {
pid="begin"
for stringstart in `echo "$includestringstart" | sed 's/|/\ /g'`
do
if [ ! -z "$pid" ]
then
findpidstart $stringstart
fi
done
}

findpidstart() {
if [ ! -z "$excludestringstart" ]
then
if [ ! -z "$1" ];then pid="$("$ps" "$psoption" | grep -E "$1" | grep -vE "$excludestringstart" | grep -v grep | grep -v "$start_service_comand" | awk '{print $2}')"; fi
else
if [ ! -z "$1" ];then pid="$("$ps" "$psoption" | grep -E "$1" | grep -v grep | grep -v "$start_service_comand" | awk '{print $2}')"; fi
fi
}



mailsendko() {
mail -s "Cannot start service $servicename on node $iam" $mailto <<EOF

${iam}: The start sequence of service $servicename is NOT succesfully completed.
SERVICE NOT STARTED.
Consider to control the presence of the service $servicename on node $iam.
This is number $countstart of $countstartlimit tries.

EOF
}

mailsendok() {
mail -s "Service $servicename on node $iam started." $mailto <<EOF

${iam}: The start sequence of service $servicename is SUCCESSEFULLY completed.

EOF
}

controlstop () {
count="0"
while [ $count -lt $timeoutstop ]
do
sleep 1
findpidstop
if [ ! -z "$pid" ]
then
count=$(($count + 1))
echo "Waiting for process $pid to stop service $servicename. Number of try $count..."
else
echo "Ok. The stopping process is terminated."
count="$timeoutstop"
fi
done

if [ ! -z "$stop_service_comand_2" ]
then
findpidstop

if [ ! -z "$pid" ]
then
echo "Timeout reached for script ${stop_service_comand} to kill process ${pid}."
echo "So i try to stop the service with the script ${stop_service_comand_2}..."

$stop_service_comand_2 &

count="0"
while [ $count -lt $timeoutstop_2 ]
do
sleep 1
findpidstop
if [ ! -z "$pid" ]
then
count=$(($count + 1))
echo "Waiting for process $pid to stop service $servicename. Number of try $count..."
else
echo "Ok. The stopping process is terminated."
count="$timeoutstop"
fi
done
fi
fi


findpidstop
if [ ! -z "$pid" ]
then
echo "Timeout reached for process $pid to stop service. I kill it."
kill -9 $pid
fi
}

controlstart () {
count="0"
while [ $count -lt $timeoutstart ]
do
sleep 1
teststart
if [ -z "$pid" ]
then
count=$(($count + 1))
echo "Waiting for service $servicename to start. Number of try $count..."
else
count="$timeoutstart"
fi
done
teststart
if [ -z "$pid" ]
then
if [ -z "$countstart" ]; then countstart=0 ; fi
countstart=$(($countstart + 1))
echo "Timeout reached for starting service $servicename: SERVICE NOT STARTED. This is number $countstart of $countstartlimit tries."
mailsendko
if [ $countstart -lt $countstartlimit ]
then
$0 "$servicename" "$log" "$start_service_comand" "$stop_service_comand" "$includestringstart" "$excludestringstart" "$includestringstop" "$excludestringstop" "$timeoutstop" "$timeoutstart" "$ps" "$psoption" "$mailto" "$iam" "$countstartlimit" "$countstart" "$begincheck" "$stop_service_comand_2" "$timeoutstop_2" stop
$0 "$servicename" "$log" "$start_service_comand" "$stop_service_comand" "$includestringstart" "$excludestringstart" "$includestringstop" "$excludestringstop" "$timeoutstop" "$timeoutstart" "$ps" "$psoption" "$mailto" "$iam" "$countstartlimit" "$countstart" "$begincheck" "$stop_service_comand_2" "$timeoutstop_2" start &
fi
else
echo "The start sequence of service $servicename is SUCCESSEFULLY completed."
mailsendok
fi

}


exec >> "$log" 2>&1

case ${20} in
start)
if [ ! -z "$start_service_comand" ]
then 
$start_service_comand &
sleep "${17}"
fi
controlstart
;;
stop)
if [ ! -z "$stop_service_comand" ]
then 
$stop_service_comand &
fi
controlstop
;;
esac
