/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kokmainwidget.h"

#include "qapplication.h"
#include "rm.h"
#include "cocktailfileparser.h"
#include "searchdialogext.h"
#include "qmessagebox.h"
#include "qtabbarext.h"
#include <qlayout.h>
#include <qsettings.h>
#include "dlgPref.h"

#define APP_NAME "cocktail/"

//to be able to access the HOME variable
#ifdef Q_WS_X11
#include <stdlib.h>
#endif






kokMainWidget::kokMainWidget(QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	QGridLayout * gl = new QGridLayout(this,2,2);
	nameListBox = new QListBox(this);
	tabWidget = new QTabBarExt(this);
	recipeAllTextEdit = new QTextEdit(this);

	gl->addMultiCellWidget(nameListBox,0,1,0,0);
	gl->addWidget(tabWidget,0,1);
	gl->addWidget(recipeAllTextEdit,1,1);
	nameListBox->setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Expanding);
	recipeAllTextEdit->setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);

#ifdef Q_WS_X11
	QString HOME = getenv("HOME");
	QString fileName = HOME +"/share/cocktail/cocktails_list.xml";
#elif defined(Q_WS_WIN)
	cerr << "you need to modify the program to make it work on Windows platform"<<endl;
	exit(1);
#elif defined(Q_WS_MACX)
	cerr << "you need to modify the program to make it work on MacOS platform"<<endl;
	exit(1);
#endif


	cocktailFileParser::readCocktailsFromFile(fileName,&allRecipes,&dicoFind);

	allElementsName = new QStringList(RM::getListOfElementsName(&dicoFind));
	allElementsName->sort();

	QValueVector<recipe *>::iterator it;
	allNames = new QStringList;

	for( it = allRecipes.begin(); it != allRecipes.end(); ++it ){
		allNames->append( (*it)->getName() );
		dicoAll.insert( (*it)->getName(),(*it));
	}

	connect(nameListBox ,  SIGNAL(highlighted(const QString &)) ,  this ,  SLOT(itemHighlighted(const QString &)));
	connect(tabWidget,SIGNAL(closeAllTab()), this , SLOT(closeAllTab())); 
	connect(tabWidget,SIGNAL(closeThisTab(QString)),this,SLOT(closeThisTab(QString ))); 
	connect(tabWidget, SIGNAL( selected(int) ), this, SLOT( newTabSelected(int) ) );
	recipeAllTextEdit->setTextFormat(Qt::RichText);
	recipeAllTextEdit->setReadOnly(true);

	searches.append(searchResult("&All",*allNames));
	tabWidget->addTab(new QTab("&All"));
	this->newTabSelected("&All");



	QSettings settings;
	QString app_name = APP_NAME;
	QString unitsStr = settings.readEntry( app_name + "units", "cl" );
	if (unitsStr=="cl")
		userUnits = cl;
	else if (unitsStr=="oz")
		userUnits = oz;

	cerr <<"end of the initialisation"<<endl;
}


kokMainWidget::~kokMainWidget()
{
}



void kokMainWidget::fileNew()
{

}


void kokMainWidget::fileOpen()
{

}


void kokMainWidget::fileSave()
{

}


void kokMainWidget::fileSaveAs()
{

}


void kokMainWidget::filePrint()
{

}


void kokMainWidget::fileExit()
{
//    if ( okToClear() ) {
	saveOptions();
	qApp->exit( 0 );
//}
}

void kokMainWidget::saveOptions()
{
	QSettings settings;
	QString app_name = APP_NAME;
        settings.writeEntry( app_name + "WindowWidth", width() );
        settings.writeEntry( app_name + "WindowHeight", height() );
        settings.writeEntry( app_name + "WindowX", x() );
        settings.writeEntry( app_name + "WindowY", y() );

	
	if (userUnits==cl)
		settings.writeEntry( app_name + "units", "cl" );
	else if (userUnits==oz)
		settings.writeEntry( app_name + "units", "oz" );
}

void kokMainWidget::setUserUnits(units userUnits)
{
	this->userUnits=userUnits;
}

void kokMainWidget::editUndo()
{

}


void kokMainWidget::editRedo()
{

}


void kokMainWidget::editCut()
{

}

void kokMainWidget::editPref()
{
	dlgPref * dp = new dlgPref(this);
	connect(dp,SIGNAL(emitPref(cockPref)),this,SLOT(setPref(cockPref)));
	cockPref pref;
	pref.setUserUnits(userUnits);
	dp->setPref(pref);
	dp->show();
}

void kokMainWidget::setPref(cockPref pref)
{
	userUnits=pref.getUserUnits();
}

void kokMainWidget::itemHighlighted(const QString  & str)
{
	cerr << "item selected, displaying the content"<<endl;
	recipe * curRecipe = *(dicoAll.find(str));
	recipeAllTextEdit->setText(curRecipe->toRichTextString(userUnits));
}


void kokMainWidget::editPaste()
{

}


void kokMainWidget::editFind()
{
	QStringList searchName;
	for (unsigned i=0; i< searches.size() ;++i)
		searchName.append(searches[i].getName());

	searchDialogExt * sd=new searchDialogExt(*allElementsName,searchName);
	connect(sd,SIGNAL(searchRequestEmitted(searchRequest)),this, SLOT(newSearchRequest( searchRequest)));
	sd->show();
}


void kokMainWidget::helpIndex()
{

}


void kokMainWidget::helpContents()
{

}


void kokMainWidget::helpAbout()
{
    QMessageBox::about( this, "About cocktail",
        "cocktail is a simple cocktail recipes manager\n\n"
        "Copyright 2005 Bertrand Haut.\n"
        "released under the GPL license\n");
}


void kokMainWidget::newSearchRequest( searchRequest sr)
{
	QStringList results;
	if (sr.getWithout().size() ==0 )
		results = RM::getRecipeContaining(dicoFind , sr.getWith(),sr.getBool());
	else
	results = RM::getRecipeContaining(dicoFind , sr.getWith(), sr.getWithout() , sr.getBool());


	//create a new tab with the results
	searches.append(searchResult(sr.getName(),results));
	tabWidget->addTab(new QTab(sr.getName()));
	tabWidget->update();
}


void kokMainWidget::newTabSelected( int id )
{
	this->newTabSelected(tabWidget->tab(id)->text());
}


void kokMainWidget::closeAllTab()
{
	searches.erase(searches.begin()+1 , searches.end()); 

	//we reselect the first tab
	this->newTabSelected(0);
}


void kokMainWidget::newTabSelected( QString str )
{
	cerr<<"newTabSelected signal received "<<str<<endl;
	nameListBox->clear();
	if (str=="&All")
	nameListBox->insertStringList(*allNames);
	else{
		unsigned i=0;
		for ( ; i < searches.size() ; ++i)
			if (searches[i].getName()==str)
				break;
		QStringList newList = searches[i].getResults();
		nameListBox->insertStringList( newList );
		if (nameListBox->count()==0)
			recipeAllTextEdit->clear();
		else
			nameListBox->setCurrentItem(0);
	}
}


void kokMainWidget::closeThisTab( QString name )
{
	QValueVector<searchResult>::iterator it;
	for (it=searches.begin() ; it!=searches.end() ; ++it)
		if ((*it).getName()==name){
			searches.erase(it);
			break;
		}

}


void kokMainWidget::closeAllOther( QString name )
{
	QValueVector<searchResult>::iterator it;
	for (it=searches.begin() ; it!=searches.end() ; ++it)
		if (((*it).getName()!=name)&& (((*it).getName()!="&All"))){
			searches.erase(it);
			break;
		}
}

