/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "recipe.h"
#include <qtextstream.h>


Element::Element(QString name)
{
	this->name=name;
	this->quantity=0;
}

Element::Element(QString name, double quantity)
{
	this->name=name;
	this->quantity=quantity;
}

QString Element::getName()
{
	return name;
}

double Element::getQuantity()
{
	return quantity;
}


recipe::recipe(QString name, bool proportional, int nbrGlasses, QValueVector<liquidElement *> liquidElements, QValueVector<otherElement *> otherElements,QString comment)
{
	this->name = name;
	this->proportional=proportional;
	this->nbrGlasses=nbrGlasses;
	this->liquidElements=liquidElements;
	this->otherElements=otherElements;
	this->comment=comment;
}

recipe::~recipe()
{
}

QString recipe::getName()
{
	return name;
}

QString recipe::getComment()
{
	return comment;
}
QString recipe::getGlassType()
{
	return glassType;
}

int recipe::getNbrGlasses()
{
	return nbrGlasses;
}

bool recipe::getProportional()
{
	return proportional;
}

QValueVector<liquidElement *> recipe::getLiquidElements()
{
	return liquidElements;
}

QValueVector<otherElement *> recipe::getOtherElements()
{
	return otherElements;
}

QStringList recipe::getLiquidElementsNameList()
{
	QStringList liquidElementsNameList;
	QValueVector<liquidElement *> le = this->getLiquidElements();
	QValueVector<liquidElement *>::iterator it;
	for (it=le.begin() ; it != le.end(); ++it){
		liquidElementsNameList.append( (*it)->getName() );
	}
	return liquidElementsNameList;
}

QString recipe::toString()
{
	QString str;
	QTextStream recipeString(&str, IO_WriteOnly);
	
	recipeString << name <<endl<<endl;
	if (nbrGlasses!=1)
		recipeString << "For "<<nbrGlasses<<" glasses"<<endl;
	if (!glassType.isEmpty())
		recipeString <<"To be served in a glass of type : "<<glassType<<endl;
	if (!comment.isEmpty())
		recipeString << comment<<endl<<endl;
		
	if (proportional){
		//First calculation of the total quantity
		double totQuant=0;
		for (unsigned i =0; i <liquidElements.size();++i)
			totQuant+=liquidElements[i]->getQuantity();
		for (unsigned i =0; i <liquidElements.size();++i)
			recipeString <<liquidElements[i]->getQuantity() <<"/"<<totQuant<<" of "<<liquidElements[i]->getName()<<endl;
	}
	else
		for (unsigned i =0; i <liquidElements.size();++i)
			if (liquidElements[i]->getQuantity()==0)
				recipeString <<liquidElements[i]->getName()<<endl;
			else
				recipeString <<liquidElements[i]->getQuantity() <<" cl of "<<liquidElements[i]->getName()<<endl;
	recipeString<<endl;

	for (unsigned i =0; i <otherElements.size();++i)
		if (otherElements[i]->getQuantity()==0)
			recipeString <<otherElements[i]->getName()<<endl;
		else
			recipeString <<otherElements[i]->getQuantity() <<" "<<otherElements[i]->getName()<<endl;

	return str;
}


QString recipe::toRichTextString(units userUnits)
{
	QString str;
	QTextStream recipeString(&str, IO_WriteOnly);
	recipeString <<"<h1>" <<QString(name).replace(0,1,name.left(1).upper()) <<"</h1>";
	if (nbrGlasses!=1)
		recipeString << "For "<<nbrGlasses<<" glasses"<<"<br/>";
	if (!glassType.isEmpty())
		recipeString <<"To be served in a glass of type : "<<glassType<<"<br/>";
	if (!comment.isEmpty())
		recipeString << "<i>"<<comment<<"</i><br/><br/>";
		
	if (proportional){
		//First calculation of the total quantity
		double totQuant=0;
		for (unsigned i =0; i <liquidElements.size();++i)
			totQuant+=liquidElements[i]->getQuantity();
		for (unsigned i =0; i <liquidElements.size();++i)
			recipeString <<liquidElements[i]->getQuantity() <<"/"<<totQuant<<" of "<<liquidElements[i]->getName()<<"<br/>";
	}
	else
		for (unsigned i =0; i <liquidElements.size();++i)
			if (liquidElements[i]->getQuantity()==0)
				recipeString <<liquidElements[i]->getName()<<"<br/>";
			else
				if (userUnits ==cl)///TODO round the quantity (preferences of user?)
					recipeString <<liquidElements[i]->getQuantity() <<" cl of "<<liquidElements[i]->getName()<<"<br/>";
				else
					recipeString <<liquidElements[i]->getQuantity()/ozToCl <<" oz of "<<liquidElements[i]->getName()<<"<br/>";
	recipeString<<"<br/>";

	for (unsigned i =0; i <otherElements.size();++i)
		if (otherElements[i]->getQuantity()==0)
			recipeString <<otherElements[i]->getName()<<"<br/>";
		else
			recipeString <<otherElements[i]->getQuantity() <<" "<<otherElements[i]->getName()<<"<br/>";

	return str;
}
