/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RECIPE_H
#define RECIPE_H
#include <qvaluevector.h>
#include <qstringlist.h>
#include "common.h"

// basic Element of a cocktail (a name + a quantity)
class Element{
public:
	Element(QString name);
	Element(QString name, double quantity);
	QString getName();
	double getQuantity();

protected:
	QString name;
	//! a quantity of 0 correspond to "fill with"
	double quantity;
};

/** Element of the cocktail that is a measurable liquid
ex : 1cl gin, 2cl vodka, orange juice,... */
class liquidElement: public Element{
public:
	liquidElement(QString name):Element(name){};
	liquidElement(QString name, double quantity):Element(name,quantity){};
};

/** Element of the cocktail that is not a measurable liquid
ex : orange slice, egg, a drop of grenadine */
class otherElement: public Element{
public:
	otherElement(QString name):Element(name){};
	otherElement(QString name, double quantity):Element(name, quantity){};
};

//!contains the complete description of the recipe of a cocktail

/**
Contains the complete description of the recipe of a cocktail :
	- the name
	- the type of glass used to serve the cocktail
	- for how many glasses, the cocktail is expected
	- the differents elements of the cocktail
	- are the quantities in "cl" or in a proportional form
*/


class recipe{
public:
	recipe(QString name, bool proportional, int nbrGlasses, QValueVector<liquidElement *> liquidElements, QValueVector<otherElement *> otherElements, QString comment);

	QString getName();
	QString getComment();
	QString getGlassType();
	bool getProportional();
	int getNbrGlasses();
	QStringList getLiquidElementsNameList();
	QValueVector<liquidElement *> getLiquidElements();
	QValueVector<otherElement *> getOtherElements();
	
	//! returns a QString with the complete recipe of the cocktail
	QString toString();
	QString toRichTextString(units userUnits);
	~recipe();

private:
	QString name;
	QString comment;
	int nbrGlasses;
	QString glassType;
	bool proportional;
	QValueVector<liquidElement *> liquidElements;
	QValueVector<otherElement *> otherElements;
};

#endif
