/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kokmainwindow.h"
#include "kokmainwidget.h"
#include <qstatusbar.h>
#include <qimage.h>
#include <qaction.h>
#include <qkeysequence.h>
#include <qsettings.h>
#include <qiconset.h>
#include <qmessagebox.h>

#define APP_NAME "cocktail/"

static const unsigned char image2_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x00,
    0x74, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xed, 0xd5, 0xc1, 0x09, 0xc0,
    0x20, 0x0c, 0x05, 0xd0, 0x6f, 0xe9, 0x36, 0x81, 0x2c, 0x10, 0xb2, 0xff,
    0xdd, 0x85, 0xd2, 0x53, 0x85, 0xb6, 0xa9, 0x91, 0x48, 0x0f, 0x05, 0x3f,
    0x08, 0x1a, 0xf0, 0x29, 0x12, 0x10, 0xf8, 0x28, 0xc5, 0xa9, 0xd9, 0xc4,
    0xde, 0x96, 0xcd, 0x2b, 0x9a, 0xd9, 0xeb, 0x00, 0x00, 0x66, 0x0e, 0x2f,
    0xe0, 0xc2, 0x51, 0x98, 0x39, 0xc4, 0xf7, 0x0c, 0x4c, 0x44, 0x6d, 0x5e,
    0x6b, 0x35, 0x38, 0xcf, 0x92, 0x82, 0x45, 0xe4, 0xb2, 0xf6, 0xf0, 0x14,
    0xac, 0xaa, 0x8f, 0xda, 0x1d, 0x4f, 0xc1, 0xa5, 0x74, 0x1b, 0x22, 0x07,
    0x9f, 0x9d, 0x11, 0x1d, 0x96, 0xea, 0x8a, 0x91, 0x2c, 0x78, 0xc1, 0x0b,
    0xee, 0x64, 0xe6, 0x07, 0x19, 0xf5, 0x7e, 0x92, 0x03, 0xad, 0x45, 0x2a,
    0x04, 0xcc, 0x4e, 0x50, 0x20, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e,
    0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image3_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x00,
    0x99, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xed, 0x94, 0x41, 0x0e, 0x85,
    0x20, 0x0c, 0x44, 0x5f, 0x89, 0xc7, 0x36, 0x7f, 0x61, 0xbc, 0x77, 0x5d,
    0x28, 0x48, 0xa4, 0x28, 0x60, 0xff, 0xce, 0xd9, 0x54, 0x8b, 0xbe, 0x8e,
    0x13, 0x04, 0x3e, 0x1d, 0x92, 0x81, 0x77, 0xf4, 0x81, 0xa1, 0x23, 0xdc,
    0x2b, 0x34, 0xf6, 0xf4, 0x7a, 0x3d, 0xe2, 0xb8, 0x65, 0xa8, 0x84, 0x3f,
    0x40, 0x01, 0x98, 0x2a, 0x0b, 0x3d, 0x5f, 0x62, 0xc5, 0x83, 0x00, 0xaa,
    0x1a, 0xd7, 0x05, 0x50, 0x44, 0x9a, 0xb9, 0xd5, 0x07, 0xa7, 0x73, 0xa8,
    0xa4, 0xba, 0x4f, 0x92, 0xa2, 0xdf, 0x33, 0x3c, 0x64, 0xc6, 0x3b, 0xeb,
    0xbd, 0x82, 0xe5, 0xb8, 0xad, 0xde, 0xcb, 0xcc, 0x78, 0x20, 0xeb, 0x42,
    0x66, 0xc6, 0x39, 0x74, 0x5d, 0xfa, 0x80, 0xf3, 0x6f, 0xaf, 0x66, 0xc6,
    0x6f, 0xa1, 0x9c, 0x3f, 0x88, 0x2f, 0xb4, 0x70, 0xec, 0x05, 0xcd, 0xc0,
    0xbe, 0xd0, 0x78, 0x93, 0xf6, 0x8e, 0x17, 0x14, 0x92, 0x63, 0x5f, 0x68,
    0x6c, 0x3e, 0xef, 0xf6, 0xba, 0x3c, 0x8f, 0xdd, 0x36, 0x6d, 0xc4, 0xc0,
    0x45, 0x2c, 0x87, 0x81, 0xf8, 0x08, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
    0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image4_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x00,
    0xa0, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xd5, 0x95, 0x4d, 0x0a, 0x80,
    0x20, 0x10, 0x85, 0x9f, 0xd1, 0x46, 0x68, 0xe1, 0x8d, 0xe6, 0x62, 0xd2,
    0x22, 0xbc, 0x98, 0x37, 0x6a, 0x21, 0xb4, 0xac, 0x45, 0x19, 0x92, 0xc6,
    0x64, 0x69, 0xe0, 0xb7, 0xf1, 0x87, 0xf1, 0xf1, 0x1c, 0x47, 0x05, 0x2a,
    0x21, 0x8e, 0x76, 0x2d, 0xad, 0xdb, 0xfb, 0x9e, 0x99, 0xf6, 0x56, 0x8f,
    0x80, 0xb5, 0x36, 0x4b, 0x85, 0x88, 0xce, 0x35, 0x44, 0x04, 0x00, 0xe8,
    0x0a, 0x39, 0x8c, 0xe8, 0xf9, 0x90, 0x34, 0xd2, 0x29, 0x2c, 0xc3, 0x7c,
    0x8e, 0xbd, 0x53, 0x0f, 0xeb, 0x58, 0x3a, 0x05, 0xe9, 0x54, 0x34, 0x1f,
    0x8a, 0x02, 0x7b, 0x2a, 0x7d, 0x3a, 0x1f, 0x09, 0xbf, 0x85, 0x4d, 0xc5,
    0xd5, 0xd9, 0x53, 0xaa, 0x39, 0x6e, 0x4f, 0x38, 0xca, 0xb1, 0x99, 0xe2,
    0xd2, 0xe1, 0x08, 0xab, 0xe1, 0x56, 0xf8, 0x2e, 0x30, 0x97, 0x7f, 0xcb,
    0x4d, 0x8f, 0xf9, 0x42, 0xd7, 0x5d, 0xbe, 0xbe, 0xd2, 0xe1, 0x43, 0x95,
    0x3a, 0x93, 0xf6, 0xca, 0xad, 0x3d, 0x61, 0x11, 0xf4, 0x4b, 0x7d, 0x4f,
    0x82, 0x0f, 0xf9, 0xc0, 0x06, 0x9b, 0xb5, 0x1e, 0xcd, 0xed, 0x31, 0x8c,
    0x5c, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60,
    0x82
};

static const unsigned char image5_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x02,
    0x9c, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0x8d, 0x95, 0xad, 0x76, 0xdb,
    0x40, 0x10, 0x85, 0x3f, 0xf7, 0x18, 0xcc, 0x32, 0x89, 0xd9, 0x50, 0xd0,
    0x61, 0x36, 0x34, 0x4c, 0x98, 0xc3, 0x62, 0x96, 0x40, 0x87, 0x25, 0x6f,
    0x50, 0x3f, 0x42, 0x61, 0x61, 0x02, 0x1b, 0xe6, 0xb2, 0x84, 0x25, 0x50,
    0x61, 0x2e, 0x8b, 0xe1, 0x42, 0x99, 0x49, 0x6c, 0x86, 0x6d, 0xc1, 0x4a,
    0xb2, 0xfc, 0x77, 0xda, 0x21, 0x92, 0x66, 0x57, 0x77, 0xee, 0xdc, 0x3b,
    0x5a, 0xf5, 0x38, 0x13, 0xaf, 0xaf, 0xaf, 0x41, 0x44, 0x48, 0xd3, 0x74,
    0x2f, 0x6f, 0x66, 0x00, 0xa8, 0x2a, 0x00, 0x55, 0x55, 0x91, 0x24, 0x09,
    0x57, 0x57, 0x57, 0xbd, 0xee, 0xbe, 0xfe, 0x39, 0x60, 0x11, 0x61, 0x32,
    0x99, 0xb4, 0x40, 0x87, 0x6b, 0x4d, 0x94, 0x65, 0x89, 0xf7, 0xfe, 0x68,
    0xcf, 0x59, 0x60, 0x80, 0xcd, 0x66, 0x73, 0x04, 0x76, 0x58, 0x48, 0x55,
    0x71, 0xce, 0xfd, 0x3f, 0xf0, 0x29, 0x00, 0x33, 0x3b, 0x2a, 0x70, 0xaa,
    0x23, 0x80, 0x6f, 0xa7, 0x92, 0x79, 0x9e, 0x07, 0x33, 0x6b, 0x99, 0x38,
    0xe7, 0x70, 0xce, 0xed, 0xe9, 0xdd, 0xe8, 0x2f, 0x22, 0x47, 0xfa, 0x9e,
    0x65, 0xac, 0xaa, 0x24, 0x49, 0x42, 0x59, 0x96, 0x88, 0x48, 0x6b, 0x54,
    0x37, 0x4e, 0xb5, 0xff, 0x4f, 0xc6, 0x10, 0x5b, 0x3c, 0x9c, 0x88, 0x2e,
    0x68, 0x53, 0xec, 0x9c, 0x14, 0x27, 0x19, 0x37, 0x6c, 0x4e, 0x31, 0xed,
    0xe6, 0x55, 0x75, 0x6f, 0x42, 0xba, 0x71, 0xa4, 0x0d, 0xc0, 0x6a, 0xb5,
    0x0a, 0x59, 0x96, 0x31, 0x1c, 0x0e, 0xcf, 0x82, 0x37, 0x46, 0x7e, 0x7e,
    0x7e, 0x02, 0x20, 0x92, 0x30, 0x9f, 0x5f, 0xb7, 0x78, 0x7b, 0x8c, 0xdf,
    0xdf, 0xdf, 0x83, 0xf7, 0x9e, 0xfc, 0x23, 0x47, 0x66, 0x82, 0x88, 0xb4,
    0x00, 0x87, 0xd7, 0x86, 0x69, 0x59, 0x94, 0xe4, 0x79, 0xce, 0xb6, 0xda,
    0xf2, 0xf0, 0xf0, 0x10, 0x66, 0xb3, 0x19, 0xd7, 0xd7, 0xd7, 0xbd, 0x5e,
    0x17, 0x74, 0xb3, 0xf1, 0x54, 0xc5, 0x16, 0x35, 0x80, 0xd3, 0x4c, 0x01,
    0x9c, 0xa4, 0x08, 0x02, 0x0e, 0x7c, 0xe1, 0x59, 0xaf, 0xff, 0xb0, 0xdd,
    0x16, 0xa8, 0x1a, 0x17, 0x17, 0x19, 0x8b, 0xc5, 0x22, 0x4a, 0xd1, 0x30,
    0xbd, 0x9c, 0x5e, 0xe2, 0xd2, 0x14, 0x55, 0x03, 0x53, 0x8e, 0x6c, 0x31,
    0x03, 0x84, 0x9c, 0x4f, 0x3e, 0x78, 0x65, 0x6a, 0x53, 0xd2, 0xaf, 0x94,
    0xe7, 0x97, 0x67, 0xfc, 0x57, 0xfc, 0xfa, 0xd4, 0x94, 0x6c, 0x74, 0x11,
    0x41, 0x9f, 0x9e, 0x7e, 0x85, 0xb2, 0x28, 0xc3, 0xff, 0xc4, 0x57, 0xf8,
    0x0a, 0xa3, 0x30, 0x0a, 0x12, 0x24, 0x8c, 0xc2, 0x28, 0xac, 0xd7, 0xeb,
    0xf0, 0xe3, 0xfb, 0xcf, 0x30, 0x1e, 0x8f, 0xc3, 0x60, 0x90, 0x85, 0x24,
    0x49, 0x42, 0x36, 0xc8, 0x42, 0xbf, 0xda, 0x56, 0xdc, 0xdd, 0xdd, 0x9c,
    0x75, 0xf7, 0x30, 0x52, 0x52, 0x2e, 0x99, 0x92, 0x23, 0xcc, 0x98, 0x31,
    0x1e, 0x8f, 0x49, 0x64, 0x48, 0x69, 0x05, 0xcf, 0xbf, 0x5e, 0xa8, 0xaa,
    0x8a, 0x74, 0x90, 0xd2, 0x37, 0xc0, 0xfb, 0x22, 0xce, 0xa3, 0x19, 0x88,
    0x10, 0x6b, 0x48, 0xed, 0x36, 0x38, 0x5c, 0x54, 0xdc, 0x14, 0xc4, 0xf1,
    0x60, 0xdf, 0xb9, 0xc1, 0x33, 0xb4, 0x21, 0x7f, 0xd8, 0x80, 0x19, 0xe9,
    0x70, 0x18, 0xd7, 0x6b, 0x77, 0xfa, 0x65, 0x51, 0xe0, 0x45, 0xa2, 0x9e,
    0x66, 0xb4, 0xbe, 0x39, 0x88, 0x2e, 0xd6, 0x9d, 0x38, 0x03, 0x15, 0x20,
    0xe6, 0x04, 0xf0, 0xb6, 0xc5, 0x88, 0x67, 0x88, 0xdf, 0x6c, 0x5a, 0x4f,
    0x1c, 0xf5, 0xb8, 0x35, 0x09, 0x6b, 0x00, 0xb1, 0x76, 0x28, 0x14, 0x8b,
    0x35, 0x74, 0x6f, 0x67, 0x3b, 0x39, 0xd2, 0x78, 0xda, 0x09, 0x45, 0xe9,
    0x23, 0x60, 0x65, 0xe7, 0x05, 0xad, 0xc9, 0x76, 0x37, 0x1a, 0x20, 0x0a,
    0x76, 0xb8, 0xe2, 0x30, 0x2b, 0xa9, 0xfb, 0x6c, 0x7a, 0x63, 0x32, 0x99,
    0xf2, 0x0d, 0xeb, 0xb0, 0x6c, 0xc9, 0x6a, 0x7c, 0xb4, 0xfa, 0xba, 0x07,
    0xea, 0x9a, 0x6d, 0x35, 0x68, 0x0d, 0x58, 0xcb, 0x39, 0x18, 0x0c, 0x58,
    0x2c, 0xee, 0x22, 0x63, 0xef, 0x7d, 0x63, 0x15, 0x88, 0x41, 0x25, 0x40,
    0x15, 0x9d, 0x33, 0x8b, 0x30, 0xd2, 0xb0, 0xb2, 0x1d, 0x18, 0x3b, 0xcd,
    0x31, 0x43, 0x04, 0x96, 0xcb, 0x25, 0xf3, 0xf9, 0xbc, 0xd7, 0xcf, 0xb2,
    0x8c, 0x8f, 0xb7, 0x0f, 0x7e, 0xbf, 0xbd, 0xa1, 0x6a, 0xc4, 0xf3, 0x47,
    0xd8, 0x1b, 0x3e, 0xe9, 0x3c, 0xcb, 0x0e, 0xb2, 0xed, 0xb3, 0x9e, 0xa6,
    0xe5, 0x72, 0xc9, 0xe3, 0xe3, 0x63, 0x0f, 0x3a, 0x87, 0xd0, 0x6a, 0xb5,
    0x0a, 0xab, 0xd5, 0x1b, 0xdb, 0xfa, 0xff, 0xa5, 0x68, 0x6d, 0xca, 0xce,
    0x99, 0xdd, 0x5f, 0x03, 0x54, 0xcb, 0x78, 0x5f, 0x19, 0x93, 0xe9, 0x84,
    0xdb, 0xdb, 0x5b, 0xee, 0xef, 0xef, 0x5b, 0xbc, 0xbf, 0xd1, 0xf6, 0x9e,
    0x0c, 0x3f, 0xec, 0x24, 0x86, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e,
    0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image6_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x04,
    0x57, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xa5, 0x95, 0xcd, 0x4f, 0x54,
    0x57, 0x18, 0xc6, 0x7f, 0xe7, 0x9c, 0x3b, 0x77, 0x60, 0x66, 0x98, 0x96,
    0xf1, 0x62, 0x43, 0x05, 0x04, 0x43, 0x94, 0x88, 0x2c, 0x2c, 0x28, 0x92,
    0x58, 0xa3, 0x12, 0x35, 0x36, 0x71, 0x61, 0xe2, 0x8a, 0x85, 0xd1, 0xa5,
    0x0b, 0x57, 0xa6, 0x4b, 0x57, 0xea, 0xae, 0x24, 0xea, 0xc2, 0x85, 0x5b,
    0x13, 0xfa, 0x07, 0x88, 0x64, 0xec, 0xc6, 0x84, 0xb8, 0x82, 0x51, 0x3a,
    0x52, 0xc5, 0x54, 0x8b, 0x16, 0xac, 0x7c, 0x88, 0xc0, 0xcc, 0xbd, 0xcc,
    0x17, 0x33, 0xe7, 0x74, 0x71, 0xef, 0x8c, 0xd8, 0x36, 0xdd, 0xf8, 0x26,
    0x27, 0xe7, 0x4d, 0xee, 0xb9, 0xcf, 0x79, 0xce, 0xf3, 0x7e, 0x89, 0x1f,
    0xa1, 0x25, 0xa4, 0xd4, 0xb5, 0x5d, 0x8e, 0x33, 0x64, 0x29, 0x65, 0xf3,
    0x05, 0x56, 0xae, 0x54, 0x4a, 0xb3, 0x2b, 0x2b, 0x23, 0x9b, 0x95, 0xca,
    0x55, 0x2b, 0xa4, 0xd4, 0xb5, 0x2b, 0x27, 0x4f, 0x5e, 0xc8, 0xe7, 0xf3,
    0xac, 0xb8, 0x2e, 0x18, 0xf3, 0xd9, 0x61, 0x29, 0x04, 0x52, 0x4a, 0xa4,
    0x10, 0xa8, 0x60, 0x97, 0xff, 0xdc, 0x03, 0x3f, 0x5a, 0x57, 0x67, 0x97,
    0xe1, 0xc2, 0x4f, 0x0f, 0x1f, 0x62, 0x75, 0x38, 0xce, 0xd0, 0x46, 0x2e,
    0xc7, 0xc2, 0xee, 0xdd, 0x24, 0x7a, 0x7b, 0x3f, 0x03, 0x15, 0xd5, 0x9f,
    0x84, 0x40, 0x85, 0xc3, 0x08, 0x21, 0x10, 0xe5, 0x32, 0x52, 0x08, 0xdf,
    0x0f, 0xbe, 0x55, 0xfd, 0x8d, 0xe7, 0xcf, 0x89, 0xa6, 0xd3, 0x74, 0x38,
    0xce, 0x90, 0x65, 0x49, 0x69, 0xaf, 0xb8, 0x2e, 0x0d, 0x9d, 0x9d, 0xe8,
    0x72, 0xf9, 0x33, 0xa6, 0xd1, 0x8e, 0x0e, 0xec, 0x8e, 0x0e, 0xc2, 0x4d,
    0x4d, 0x44, 0x12, 0x09, 0x00, 0x36, 0x3e, 0x7e, 0x64, 0x63, 0x69, 0x89,
    0xdc, 0xab, 0x57, 0xc4, 0xd6, 0xd7, 0x61, 0x0b, 0x70, 0xb8, 0xbd, 0x9d,
    0x52, 0x2a, 0x85, 0x25, 0xa5, 0x6d, 0x19, 0xc0, 0x18, 0xc3, 0x66, 0x36,
    0x8b, 0xde, 0xdc, 0x04, 0xc0, 0xaa, 0xaf, 0x67, 0xdb, 0x89, 0x13, 0x34,
    0xf6, 0xf4, 0xfc, 0x4b, 0xc7, 0x98, 0xe3, 0x10, 0x73, 0x1c, 0xe8, 0xee,
    0xe6, 0xcf, 0x89, 0x09, 0x54, 0x2a, 0x45, 0xbd, 0x31, 0x20, 0x25, 0xa2,
    0x58, 0x44, 0x08, 0x81, 0x01, 0x2c, 0x8c, 0x01, 0x63, 0x28, 0x65, 0x32,
    0xa8, 0x62, 0x11, 0x3b, 0x12, 0x61, 0xe7, 0xa5, 0x4b, 0xd4, 0x05, 0x0c,
    0x7f, 0x7b, 0xf4, 0x88, 0x0f, 0xcf, 0x9e, 0x51, 0x59, 0x5a, 0x22, 0x1e,
    0x0e, 0x63, 0x35, 0x37, 0x93, 0xe8, 0xe9, 0xa1, 0x7d, 0x60, 0x80, 0x9d,
    0x07, 0x0f, 0xe2, 0xee, 0xda, 0xc5, 0xfb, 0xbb, 0x77, 0x69, 0xb2, 0x2c,
    0xd8, 0xdc, 0x44, 0x00, 0x18, 0x83, 0xa5, 0x8d, 0x41, 0x1b, 0xc3, 0xea,
    0xe4, 0x24, 0x89, 0x7d, 0xfb, 0xf8, 0xe6, 0xdc, 0x39, 0xea, 0x12, 0x09,
    0x72, 0x99, 0x0c, 0xbf, 0x0c, 0x0f, 0xb3, 0xfd, 0xfd, 0x7b, 0x5a, 0x62,
    0x31, 0x5f, 0xeb, 0x62, 0x11, 0xe9, 0xba, 0xc8, 0xd7, 0xaf, 0x79, 0x93,
    0x4e, 0xd3, 0x3c, 0x34, 0x44, 0x83, 0xe3, 0xa0, 0x0e, 0x1f, 0x66, 0x33,
    0x99, 0xc4, 0x36, 0x06, 0x03, 0x68, 0x63, 0x90, 0xc6, 0x18, 0x5f, 0x8a,
    0x85, 0x05, 0x42, 0xd1, 0x28, 0x4e, 0x7f, 0x3f, 0x00, 0x63, 0x37, 0x6e,
    0xd0, 0x3e, 0x3b, 0x4b, 0x63, 0xa5, 0x82, 0xf1, 0x3c, 0xbe, 0x3a, 0x79,
    0x12, 0x75, 0xf4, 0x28, 0x85, 0x4c, 0x06, 0x3c, 0x0f, 0x7b, 0x7a, 0x9a,
    0xcc, 0xbd, 0x7b, 0x00, 0x74, 0x1e, 0x39, 0xc2, 0xbb, 0xc6, 0x46, 0xc8,
    0xe5, 0x10, 0x81, 0xb4, 0xb2, 0x9a, 0x5c, 0x4a, 0x29, 0x9a, 0x4e, 0x9d,
    0x02, 0xe0, 0xd7, 0xfb, 0xf7, 0x89, 0xa7, 0xd3, 0x58, 0xf9, 0x3c, 0xc6,
    0x75, 0xa9, 0x6f, 0x6f, 0xc7, 0x39, 0x7d, 0x9a, 0xb6, 0x33, 0x67, 0x7c,
    0x00, 0xd7, 0x05, 0xcf, 0xc3, 0xa4, 0x52, 0xac, 0x8e, 0x8f, 0x03, 0x10,
    0xef, 0xeb, 0x23, 0xb7, 0xb4, 0x84, 0x01, 0x0c, 0xf8, 0x8c, 0xa5, 0x10,
    0x58, 0x4a, 0x11, 0xef, 0xee, 0x06, 0x60, 0x76, 0x74, 0x94, 0x6d, 0xd9,
    0x2c, 0x3a, 0x9b, 0xc5, 0xb8, 0x2e, 0x52, 0xa9, 0x5a, 0xf0, 0x74, 0x28,
    0x04, 0x9e, 0x07, 0xae, 0x8b, 0xf0, 0x3c, 0x54, 0x2a, 0x05, 0xc0, 0xf6,
    0xce, 0x4e, 0x56, 0x17, 0x17, 0x6b, 0x8c, 0x2d, 0x13, 0xe8, 0x12, 0x8e,
    0xc7, 0x89, 0xb6, 0xb5, 0x01, 0x90, 0x7f, 0xf9, 0x12, 0x51, 0x28, 0x60,
    0x4a, 0x25, 0x4c, 0x28, 0x04, 0xc5, 0xe2, 0xa7, 0xb4, 0x28, 0x95, 0xc0,
    0xf3, 0xfc, 0xcb, 0x8c, 0xa1, 0x9c, 0x4e, 0xfb, 0x8c, 0x5b, 0x5a, 0xc8,
    0xd8, 0x36, 0x3b, 0xaa, 0xc0, 0xda, 0x18, 0x44, 0xc0, 0xb8, 0x6a, 0xf5,
    0x4a, 0xa1, 0xa4, 0xf4, 0x17, 0x20, 0xb5, 0xfe, 0x94, 0xdf, 0xc6, 0x60,
    0x69, 0x8d, 0x34, 0xc6, 0xaf, 0xbc, 0x2d, 0x95, 0x5a, 0x0c, 0xfc, 0x5a,
    0xf0, 0x30, 0x06, 0x91, 0xcb, 0xe1, 0xcd, 0xcf, 0x03, 0x10, 0xd9, 0xbb,
    0xd7, 0x07, 0x55, 0x0a, 0x2b, 0x28, 0xdb, 0xad, 0x85, 0xb3, 0xb5, 0x9c,
    0xed, 0x3d, 0x7b, 0x00, 0xc8, 0xbe, 0x7b, 0xc7, 0xd7, 0xe5, 0x32, 0x46,
    0xeb, 0x20, 0x78, 0x81, 0xc6, 0x4a, 0x29, 0x72, 0x33, 0x33, 0x00, 0xb4,
    0x0c, 0x0e, 0x82, 0x94, 0x58, 0x01, 0xeb, 0xad, 0x8c, 0x8d, 0xd6, 0x48,
    0x29, 0x51, 0x41, 0xef, 0xb0, 0x0e, 0x1d, 0x02, 0x60, 0x65, 0x66, 0x86,
    0xed, 0xe1, 0x30, 0xd5, 0x82, 0x93, 0x3a, 0xd0, 0x58, 0x49, 0x89, 0x97,
    0x4c, 0x02, 0xb0, 0xef, 0xec, 0x59, 0xd6, 0x7b, 0x7b, 0x6b, 0x72, 0x94,
    0xa6, 0xa6, 0xf0, 0xe6, 0xe6, 0x58, 0x7b, 0xfb, 0x96, 0xfc, 0x93, 0x27,
    0xa8, 0x80, 0xb1, 0x7d, 0xe0, 0x00, 0xe1, 0xc1, 0x41, 0x00, 0xe6, 0x92,
    0x49, 0x9c, 0x00, 0x58, 0x57, 0x81, 0x09, 0x80, 0x0b, 0x8f, 0x1f, 0xb3,
    0x38, 0x36, 0x06, 0xc0, 0x77, 0xd7, 0xaf, 0x93, 0xef, 0xeb, 0xf3, 0x19,
    0xe7, 0xf3, 0x64, 0x2f, 0x5e, 0x64, 0xfe, 0xfc, 0x79, 0x0e, 0x84, 0x42,
    0x3e, 0x68, 0x7f, 0x3f, 0xf6, 0x95, 0x2b, 0x00, 0xbc, 0x1e, 0x1b, 0xe3,
    0xdb, 0xe9, 0x69, 0x2c, 0x29, 0x31, 0x5a, 0xa3, 0xab, 0x59, 0x21, 0xc0,
    0x7f, 0xb6, 0x52, 0x6c, 0xdc, 0xba, 0xc5, 0xc6, 0xfe, 0xfd, 0x44, 0x9b,
    0x9b, 0xe9, 0xbe, 0x79, 0x93, 0xb9, 0x07, 0x0f, 0x08, 0x4d, 0x4c, 0x60,
    0xbd, 0x79, 0x43, 0x1b, 0x10, 0xea, 0xea, 0x42, 0x0c, 0x0c, 0x10, 0x39,
    0x76, 0x0c, 0x00, 0x6f, 0x61, 0x81, 0xb9, 0xdb, 0xb7, 0xf9, 0x3e, 0x16,
    0x43, 0x08, 0x81, 0x0e, 0xa4, 0x10, 0xc3, 0xb1, 0x98, 0x39, 0xda, 0xd9,
    0x49, 0x24, 0x1c, 0xae, 0x3d, 0x9d, 0x86, 0x06, 0x42, 0x97, 0x2f, 0xd3,
    0xfa, 0xc3, 0x0f, 0xfc, 0x9f, 0xfd, 0x3e, 0x3a, 0xca, 0xd2, 0x9d, 0x3b,
    0xf4, 0x86, 0x42, 0xd8, 0x4a, 0x21, 0x84, 0x60, 0x79, 0x6d, 0x8d, 0x9f,
    0x27, 0x27, 0xfd, 0x74, 0xab, 0x6a, 0x5c, 0x5b, 0xf9, 0x3c, 0x6a, 0x78,
    0x98, 0x3f, 0xc6, 0xc7, 0x91, 0xc7, 0x8f, 0x93, 0xe8, 0xea, 0x22, 0xde,
    0xda, 0xea, 0x47, 0x7f, 0x7e, 0x9e, 0x95, 0x99, 0x19, 0xfe, 0x4a, 0x26,
    0xd9, 0xf1, 0xe2, 0x05, 0x87, 0x22, 0x91, 0x5a, 0xdb, 0xac, 0x32, 0xd6,
    0xc6, 0x60, 0x55, 0xb4, 0x2e, 0xe5, 0x0b, 0x05, 0xbb, 0x31, 0x1a, 0xad,
    0xa5, 0x58, 0x75, 0x52, 0xc4, 0x9f, 0x3e, 0x45, 0x4d, 0x4d, 0x51, 0x00,
    0x96, 0xc3, 0x61, 0x36, 0xca, 0x65, 0x1a, 0xca, 0x65, 0x9a, 0x6c, 0x9b,
    0x56, 0xcb, 0x42, 0x6c, 0x01, 0xad, 0x36, 0xfc, 0x0f, 0xeb, 0xeb, 0x54,
    0xb4, 0x2e, 0x59, 0x6b, 0x85, 0xc2, 0xc8, 0x62, 0x26, 0x73, 0x41, 0x03,
    0x0d, 0xf5, 0xf5, 0xff, 0x39, 0x1d, 0xaa, 0x7b, 0x34, 0xe8, 0xb5, 0xcb,
    0xd5, 0x33, 0xe0, 0x37, 0x7a, 0xfc, 0x69, 0xb3, 0x92, 0xcd, 0xf2, 0x76,
    0x79, 0x99, 0xb5, 0x42, 0x61, 0xc4, 0xd2, 0xc6, 0x5c, 0x4d, 0x2d, 0x2e,
    0x12, 0x5f, 0x5d, 0x1d, 0x92, 0x42, 0x7c, 0xd1, 0x30, 0xd5, 0xc6, 0x94,
    0xb2, 0xa5, 0xd2, 0x88, 0x36, 0xe6, 0xea, 0xdf, 0x44, 0xcb, 0xf0, 0x2c,
    0x06, 0x86, 0x58, 0x55, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
    0xae, 0x42, 0x60, 0x82
};

static const unsigned char image7_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x00,
    0x73, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xed, 0x92, 0xc1, 0x0e, 0x80,
    0x20, 0x08, 0x40, 0xb1, 0xef, 0x66, 0x1d, 0x1c, 0xff, 0x4d, 0x87, 0x6a,
    0xa8, 0x88, 0xa1, 0x76, 0x69, 0xf9, 0x36, 0x0f, 0x28, 0x3e, 0xd8, 0x00,
    0x60, 0xf1, 0x59, 0x42, 0x5f, 0x3a, 0x71, 0xf5, 0x36, 0x02, 0xe0, 0x8e,
    0x99, 0x2b, 0x09, 0x88, 0x01, 0xd0, 0x28, 0x54, 0x17, 0x6a, 0xe4, 0x7f,
    0x21, 0xce, 0x1f, 0xb5, 0xb0, 0x5d, 0x38, 0xed, 0xdc, 0x90, 0x60, 0xd0,
    0xf1, 0x13, 0x79, 0x63, 0x5b, 0x3b, 0xc9, 0x2b, 0xd5, 0x18, 0xe2, 0x39,
    0xa9, 0x43, 0xec, 0x1d, 0x5a, 0xb7, 0x78, 0x5c, 0xee, 0x10, 0x7b, 0xe4,
    0xb2, 0x15, 0xaf, 0x40, 0x91, 0xf8, 0x94, 0xde, 0x47, 0x18, 0x1e, 0xce,
    0xa5, 0x9e, 0xde, 0x9e, 0xc5, 0x9f, 0x38, 0x00, 0x62, 0xac, 0x28, 0xb1,
    0xe3, 0xd7, 0x01, 0xd9, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
    0xae, 0x42, 0x60, 0x82
};

static const unsigned char image8_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x00,
    0x74, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xed, 0x92, 0xc1, 0x0a, 0xc0,
    0x20, 0x08, 0x40, 0x6d, 0xdf, 0x2d, 0x3b, 0x84, 0xff, 0xed, 0x0e, 0xa3,
    0x58, 0x6a, 0x26, 0xd1, 0x65, 0xe0, 0x83, 0x0e, 0xa5, 0x3e, 0x85, 0x04,
    0x48, 0x7e, 0x4b, 0x91, 0x0f, 0x54, 0x89, 0xf1, 0x9e, 0xa5, 0xa3, 0xca,
    0x0f, 0x8a, 0x89, 0x63, 0x65, 0xb3, 0x06, 0xc4, 0x2d, 0xd6, 0x13, 0xc6,
    0x49, 0xbd, 0xc2, 0x59, 0x83, 0x16, 0x13, 0x62, 0x19, 0xf0, 0xf9, 0x36,
    0xc0, 0xa2, 0xef, 0x00, 0xd7, 0x5a, 0x62, 0x61, 0x4d, 0x3a, 0xb2, 0x29,
    0x96, 0xf2, 0xa3, 0x62, 0xff, 0xa3, 0x37, 0xc5, 0xeb, 0xed, 0xe9, 0x62,
    0xaa, 0xd1, 0xa2, 0xe8, 0x4a, 0xaa, 0xa2, 0xf7, 0x50, 0xdd, 0x12, 0x74,
    0x8c, 0x0f, 0xd0, 0xab, 0x93, 0x24, 0x67, 0x78, 0x00, 0x59, 0x6e, 0x28,
    0xb1, 0x74, 0x3f, 0x46, 0x86, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e,
    0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image9_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x00,
    0x82, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xcd, 0xd3, 0x41, 0x12, 0x80,
    0x20, 0x08, 0x05, 0x50, 0xe8, 0xe0, 0x2e, 0xbc, 0x38, 0xad, 0x32, 0x73,
    0x50, 0x3e, 0x48, 0x53, 0x7f, 0xe3, 0xe4, 0x8c, 0x4f, 0x24, 0x25, 0xfa,
    0x28, 0xe2, 0x9c, 0x6f, 0x39, 0x92, 0x0b, 0xf9, 0x27, 0x6c, 0xb6, 0x01,
    0x85, 0x35, 0x88, 0x77, 0x61, 0x13, 0x88, 0xc2, 0x57, 0x64, 0x18, 0xcd,
    0xa0, 0x15, 0xf5, 0x20, 0xb4, 0xe6, 0xb5, 0x5b, 0xe1, 0x09, 0xdc, 0x06,
    0x22, 0xb8, 0xe2, 0x2a, 0xcf, 0x31, 0x05, 0x6e, 0x18, 0xdf, 0xdf, 0xf8,
    0x06, 0x06, 0xaa, 0x55, 0x1c, 0xc6, 0x35, 0x64, 0xc4, 0xdc, 0xf8, 0x0c,
    0xd0, 0x20, 0x1d, 0x57, 0x7a, 0x5c, 0x85, 0xa8, 0x84, 0x5f, 0xdc, 0x02,
    0x5e, 0xa5, 0x30, 0x7a, 0xfc, 0xcd, 0x07, 0xe2, 0x3a, 0x1d, 0xf2, 0x83,
    0xec, 0x2b, 0x37, 0xd9, 0xad, 0x5f, 0xb4, 0xdf, 0xef, 0xd4, 0x9c, 0xfb,
    0xf7, 0x2f, 0xac, 0x98, 0xc8, 0xcc, 0x89, 0x00, 0x00, 0x00, 0x00, 0x49,
    0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image10_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x00,
    0xbf, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xd5, 0x93, 0x41, 0x0a, 0x83,
    0x30, 0x10, 0x45, 0xdf, 0x48, 0x8e, 0xe5, 0x1d, 0xbc, 0x8c, 0x3b, 0xa9,
    0x8b, 0xf4, 0x6a, 0x9e, 0xab, 0xd3, 0x85, 0x35, 0x0d, 0x26, 0x63, 0x62,
    0x44, 0x4a, 0x3f, 0x0c, 0x42, 0x66, 0xfc, 0xf3, 0xf8, 0x24, 0xf0, 0x6f,
    0x12, 0x40, 0x2b, 0x66, 0xda, 0x8c, 0x55, 0xf3, 0xde, 0x22, 0x12, 0xcf,
    0x9d, 0x92, 0xcb, 0x98, 0xc0, 0xba, 0x2d, 0x7c, 0x45, 0x44, 0xcf, 0x9a,
    0x07, 0x63, 0x8b, 0xba, 0xd5, 0x3c, 0x44, 0x91, 0x23, 0x5e, 0xcf, 0x7c,
    0xc1, 0x62, 0x36, 0x97, 0xa9, 0x25, 0x40, 0xc1, 0x1f, 0xf4, 0xfd, 0xa7,
    0x52, 0x75, 0x01, 0x5d, 0x24, 0xa9, 0x38, 0x9e, 0x7d, 0x6f, 0x53, 0xdf,
    0x4f, 0xe4, 0xcc, 0xab, 0x32, 0x3e, 0xea, 0x0f, 0x03, 0xc0, 0xc4, 0xb2,
    0xa0, 0x71, 0x2c, 0xe6, 0xad, 0xd8, 0x9b, 0x59, 0xb7, 0x66, 0x1c, 0x3b,
    0xe0, 0x95, 0x98, 0x5f, 0x26, 0x16, 0x79, 0xee, 0x4e, 0xbc, 0xc2, 0x2c,
    0x97, 0x88, 0x55, 0x1f, 0xe6, 0xa2, 0xcb, 0xc4, 0x96, 0x9a, 0x89, 0x4b,
    0xcb, 0x6f, 0x23, 0xee, 0x36, 0x1a, 0xab, 0x62, 0xe2, 0x52, 0xc5, 0x72,
    0x94, 0xdf, 0xbf, 0xb6, 0x10, 0xbb, 0xf2, 0xc8, 0x97, 0xb8, 0xa4, 0x6c,
    0xc6, 0x67, 0x7e, 0xaa, 0x51, 0x95, 0x71, 0xfa, 0x08, 0x7e, 0xa8, 0x37,
    0x62, 0xda, 0x9a, 0xba, 0xcb, 0x20, 0x23, 0x5f, 0x00, 0x00, 0x00, 0x00,
    0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image11_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x00,
    0xd5, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xc5, 0x95, 0x5d, 0x0a, 0x84,
    0x30, 0x0c, 0x84, 0x27, 0xe2, 0xa9, 0x0a, 0x9e, 0x6c, 0x8b, 0x0f, 0x4b,
    0x3d, 0xd9, 0x82, 0xd7, 0xca, 0x3e, 0x58, 0xd7, 0xfe, 0x4c, 0xd0, 0xba,
    0x5d, 0x76, 0x40, 0x02, 0x4d, 0xf2, 0x65, 0xda, 0x0a, 0x05, 0x7e, 0x24,
    0x39, 0xc9, 0xeb, 0x8d, 0x9e, 0xaa, 0x88, 0x41, 0xa0, 0xc9, 0xaa, 0xd8,
    0xc8, 0x2a, 0xb3, 0x2f, 0x9c, 0x42, 0x5b, 0xe1, 0xe3, 0x0e, 0x0d, 0xcf,
    0x00, 0xc0, 0x03, 0x08, 0xf0, 0xb3, 0xa7, 0xa0, 0x74, 0x10, 0xa9, 0xd7,
    0x14, 0x2e, 0x00, 0xb4, 0x2c, 0x5a, 0x5f, 0xab, 0x69, 0x6b, 0x97, 0x9b,
    0x1c, 0x83, 0x7f, 0xc0, 0xc3, 0x16, 0xb6, 0xe4, 0x16, 0x5b, 0x64, 0xf7,
    0x8d, 0x71, 0x63, 0x59, 0x91, 0x9b, 0xdc, 0x45, 0x70, 0xde, 0x47, 0xc0,
    0x47, 0x32, 0xdd, 0x5e, 0x5b, 0xcc, 0x35, 0xf0, 0xc9, 0x77, 0x62, 0xae,
    0x78, 0x79, 0x36, 0xdc, 0xcf, 0x75, 0x13, 0x57, 0x7e, 0x79, 0xf4, 0x8c,
    0x4b, 0x27, 0xaa, 0x0f, 0x13, 0x27, 0xb2, 0x40, 0xf5, 0x11, 0x7f, 0xcb,
    0xe3, 0x48, 0xaa, 0x33, 0xb6, 0xe0, 0x22, 0x4b, 0x05, 0x4d, 0x07, 0x46,
    0xb8, 0x02, 0x5e, 0x2e, 0x3b, 0x3e, 0x73, 0xcd, 0xe0, 0xdd, 0x1c, 0x97,
    0xf0, 0x2e, 0x8e, 0xd9, 0xd0, 0xaf, 0x1d, 0xb3, 0x81, 0x22, 0x4b, 0xdf,
    0x33, 0xee, 0xe6, 0x98, 0xa9, 0x34, 0xa0, 0xf6, 0x17, 0xb4, 0x55, 0x40,
    0xd0, 0x0b, 0xcf, 0x4c, 0xa0, 0x8f, 0xc0, 0xdf, 0xf4, 0x06, 0xe3, 0x25,
    0xc1, 0x98, 0x1b, 0xc4, 0x18, 0x76, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
    0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};

static const unsigned char image12_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x16,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc4, 0xb4, 0x6c, 0x3b, 0x00, 0x00, 0x02,
    0x5d, 0x49, 0x44, 0x41, 0x54, 0x38, 0x8d, 0xd5, 0x93, 0xa1, 0x72, 0xdb,
    0x40, 0x10, 0x86, 0x3f, 0x67, 0x0a, 0x56, 0xec, 0xc4, 0x22, 0x78, 0xd0,
    0x65, 0x36, 0x93, 0xa0, 0xc2, 0x1c, 0x68, 0xd6, 0xc2, 0xe6, 0x0d, 0xf2,
    0x1a, 0x81, 0x81, 0x11, 0x34, 0x94, 0x99, 0xc2, 0x54, 0xa8, 0x32, 0x9b,
    0x55, 0xf0, 0xe0, 0x89, 0xdd, 0xb1, 0x5b, 0xa6, 0x02, 0xb7, 0x9d, 0x66,
    0x92, 0xd6, 0x99, 0xb6, 0xd3, 0x99, 0xfe, 0xe8, 0x6e, 0x67, 0xe7, 0xdb,
    0x7f, 0x77, 0xef, 0xe0, 0x7f, 0xd3, 0xe2, 0xc7, 0x4b, 0xd7, 0x75, 0xb3,
    0x73, 0x0e, 0xef, 0x3d, 0x51, 0x15, 0x00, 0x23, 0x82, 0xb5, 0x16, 0x6b,
    0x2d, 0x57, 0x57, 0x57, 0x8b, 0x17, 0x29, 0xbf, 0x02, 0xb7, 0x6d, 0x3b,
    0x0f, 0x87, 0x03, 0xb9, 0x2d, 0x58, 0xae, 0xd7, 0x60, 0x04, 0x00, 0xef,
    0x1c, 0xe3, 0xc7, 0x03, 0x06, 0xa8, 0xaa, 0x8a, 0xeb, 0xeb, 0xeb, 0x57,
    0xc1, 0x17, 0xdf, 0xa0, 0x6d, 0xdb, 0x52, 0x5d, 0xd7, 0x54, 0xef, 0xb6,
    0x00, 0xa8, 0x2a, 0x49, 0x13, 0x8a, 0x12, 0x35, 0x32, 0xec, 0x3a, 0xc4,
    0x2b, 0x9b, 0xcd, 0xe6, 0x55, 0xce, 0x2f, 0xfa, 0xbe, 0x9f, 0x87, 0xc3,
    0x40, 0xfd, 0xe1, 0x3d, 0xcb, 0x4d, 0x8d, 0xaa, 0xa2, 0x4e, 0x48, 0xee,
    0x12, 0xc6, 0x82, 0x38, 0x08, 0xc1, 0x07, 0x96, 0x9b, 0x1a, 0x8a, 0x9c,
    0xe3, 0xf1, 0xf8, 0xaa, 0x51, 0x5c, 0x38, 0xe7, 0xc8, 0xad, 0xa5, 0xaa,
    0x6b, 0x00, 0xc4, 0x5f, 0x12, 0x9c, 0x67, 0xd2, 0x23, 0x93, 0x8c, 0x88,
    0xe6, 0xc8, 0x60, 0xd1, 0x18, 0xb1, 0xd5, 0x92, 0xd1, 0x39, 0xba, 0xae,
    0x9b, 0xcf, 0x83, 0xa7, 0x89, 0x65, 0xb5, 0x46, 0x51, 0x34, 0x80, 0x1b,
    0x1d, 0x2e, 0x1f, 0x49, 0x45, 0xc0, 0xe3, 0x50, 0x09, 0x64, 0x08, 0xea,
    0x15, 0x44, 0x90, 0xc2, 0xe0, 0xbd, 0x3f, 0xef, 0x58, 0x53, 0xc2, 0xe4,
    0x86, 0xa0, 0x01, 0x9f, 0x4d, 0x84, 0xf5, 0x84, 0x18, 0x41, 0x83, 0x62,
    0xb0, 0x40, 0x8e, 0x8b, 0x23, 0xc9, 0x24, 0x50, 0x10, 0x93, 0x31, 0x4d,
    0xd3, 0x59, 0xf0, 0x1b, 0x80, 0x98, 0x14, 0x11, 0x20, 0x25, 0x14, 0x40,
    0x15, 0xf1, 0x96, 0x4c, 0x0b, 0xbc, 0x1b, 0x48, 0x4b, 0x07, 0xe4, 0x68,
    0x88, 0x80, 0xc0, 0x29, 0xeb, 0xd7, 0x8e, 0x41, 0x41, 0xf5, 0xb4, 0x34,
    0xfd, 0x76, 0x86, 0x4c, 0x05, 0x3f, 0x1e, 0x08, 0x4b, 0x0f, 0x85, 0x80,
    0x26, 0x54, 0x40, 0x63, 0x40, 0x44, 0xce, 0x83, 0x8b, 0xbc, 0xc0, 0x39,
    0x87, 0xa6, 0x13, 0x50, 0xa3, 0xa2, 0x28, 0x5e, 0x1d, 0x5a, 0x44, 0x14,
    0xd0, 0x70, 0x8a, 0xa5, 0x98, 0x08, 0x21, 0x62, 0xad, 0x3d, 0x0f, 0xb6,
    0xd6, 0xe2, 0x87, 0xcf, 0xa4, 0x98, 0x50, 0x8d, 0x27, 0x40, 0x50, 0x44,
    0x73, 0x70, 0x42, 0x8c, 0x91, 0xaf, 0x8d, 0x10, 0xfd, 0x44, 0x81, 0x60,
    0x8c, 0x39, 0x0b, 0x5e, 0x00, 0xdc, 0xdd, 0xdd, 0xcd, 0x8e, 0x80, 0xa9,
    0xde, 0x42, 0x02, 0x48, 0xe8, 0x04, 0x84, 0x08, 0x56, 0xf0, 0x3e, 0x02,
    0x90, 0x7d, 0x72, 0x94, 0x65, 0xc9, 0xba, 0x5a, 0xe3, 0x46, 0x87, 0x31,
    0xe6, 0xa7, 0x9f, 0xe5, 0x02, 0x60, 0xb5, 0x5a, 0x61, 0x02, 0xc4, 0xee,
    0x40, 0xa6, 0x89, 0x4c, 0x33, 0xf2, 0xcb, 0x0c, 0xb1, 0x06, 0x51, 0x28,
    0x14, 0xf8, 0xf8, 0x99, 0xb2, 0x2c, 0xb9, 0xb9, 0xb9, 0x59, 0xb8, 0xd1,
    0xf1, 0xf8, 0xf8, 0x48, 0xd3, 0x34, 0xb4, 0x6d, 0xfb, 0xe2, 0x9b, 0xfe,
    0x5e, 0xad, 0xef, 0xfb, 0xf9, 0x78, 0x3c, 0x32, 0x3a, 0x87, 0x18, 0x81,
    0xec, 0xb4, 0x20, 0x0d, 0x11, 0x51, 0xa8, 0xeb, 0x9a, 0xed, 0x76, 0xbb,
    0x00, 0x18, 0x86, 0x61, 0xee, 0xba, 0x8e, 0xfd, 0x7e, 0x8f, 0x31, 0x86,
    0xed, 0x76, 0xcb, 0x6a, 0xb5, 0x7a, 0xe2, 0xfe, 0x59, 0x1b, 0x5d, 0xd7,
    0xcd, 0xde, 0x7b, 0x62, 0x8c, 0x88, 0x08, 0x79, 0x9e, 0x63, 0xad, 0xa5,
    0xaa, 0xaa, 0x67, 0xb9, 0xbb, 0xdd, 0x6e, 0x6e, 0x9a, 0x06, 0xef, 0x3d,
    0x75, 0x5d, 0x3f, 0x29, 0xfe, 0xc7, 0xea, 0xfb, 0x7e, 0xbe, 0xbd, 0xbd,
    0x9d, 0xad, 0xb5, 0x73, 0x59, 0x96, 0xf3, 0xfd, 0xfd, 0xfd, 0xfc, 0xa2,
    0xe3, 0xdf, 0xd5, 0xc3, 0xc3, 0xc3, 0xdc, 0x34, 0x0d, 0xd3, 0x34, 0xb1,
    0xd9, 0x6c, 0xfe, 0x1e, 0x18, 0x4e, 0x63, 0xdc, 0xef, 0xf7, 0xa4, 0x94,
    0xfe, 0x26, 0xf6, 0x1f, 0xe9, 0x0b, 0xbc, 0x4c, 0x5e, 0x59, 0xd6, 0x14,
    0xca, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42,
    0x60, 0x82
};





kokMainWindow::kokMainWindow()
 : QMainWindow()
{
	QImage img;

	img.loadFromData( image2_data, sizeof( image2_data ), "PNG" );
	image2 = img;
	img.loadFromData( image3_data, sizeof( image3_data ), "PNG" );
	image3 = img;
	img.loadFromData( image4_data, sizeof( image4_data ), "PNG" );
	image4 = img;
	img.loadFromData( image5_data, sizeof( image5_data ), "PNG" );
	image5 = img;
	img.loadFromData( image6_data, sizeof( image6_data ), "PNG" );
	image6 = img;
	img.loadFromData( image7_data, sizeof( image7_data ), "PNG" );
	image7 = img;
	img.loadFromData( image8_data, sizeof( image8_data ), "PNG" );
	image8 = img;
	img.loadFromData( image9_data, sizeof( image9_data ), "PNG" );
	image9 = img;
	img.loadFromData( image10_data, sizeof( image10_data ), "PNG" );
	image10 = img;
	img.loadFromData( image11_data, sizeof( image11_data ), "PNG" );
	image11 = img;
	img.loadFromData( image12_data, sizeof( image12_data ), "PNG" );
	image12 = img;

	kokMainWidget * mw = new kokMainWidget(this);
	connect(mw,SIGNAL(displayMessage(QString )),this,SLOT(statusBarMessage(QString)));
	this->setCaption("cocktail");
	this->setCentralWidget(mw);

	QPopupMenu *fileMenu;
	QPopupMenu *editMenu;
	QPopupMenu *helpMenu;
	QAction* fileExitAction;
	QAction* helpAboutAction;
	QAction* editFindAction;
	QAction* editPrefAction;

	// actions
/*	fileNewAction = new QAction( this, "fileNewAction" );
	fileNewAction->setIconSet( QIconSet( image2 ) );
	fileOpenAction = new QAction( this, "fileOpenAction" );
	fileOpenAction->setIconSet( QIconSet( image3 ) );
	fileSaveAction = new QAction( this, "fileSaveAction" );
	fileSaveAction->setIconSet( QIconSet( image4 ) );
	fileSaveAsAction = new QAction( this, "fileSaveAsAction" );
	filePrintAction = new QAction( this, "filePrintAction" );
	filePrintAction->setIconSet( QIconSet( image5 ) );*/

	fileExitAction = new QAction(QIconSet( image6 ),"Exit",CTRL+Key_Q, this, "fileExitAction" );
//	fileExitAction->setIconSet( QIconSet( image6 ) );

/*	editUndoAction = new QAction( this, "editUndoAction" );
	editUndoAction->setIconSet( QIconSet( image7 ) );
	editRedoAction = new QAction( this, "editRedoAction" );
	editRedoAction->setIconSet( QIconSet( image8 ) );
	editCutAction = new QAction( this, "editCutAction" );
	editCutAction->setIconSet( QIconSet( image9 ) );
	editCopyAction = new QAction( this, "editCopyAction" );
	editCopyAction->setIconSet( QIconSet( image10 ) );
	editPasteAction = new QAction( this, "editPasteAction" );
	editPasteAction->setIconSet( QIconSet( image11 ) );*/
	editFindAction = new QAction(QIconSet( image12 ),"Search",CTRL+Key_F, this, "editFindAction" );

#include "cocktail.xpm"
	this->setIcon(QPixmap(cocktail));

#include "configure.xpm"
	QIconSet confIcon;
	confIcon.setPixmap(QPixmap(configure),QIconSet::Automatic, QIconSet::Normal);
	editPrefAction = new QAction(confIcon, "Preferences",QKeySequence() ,this,"editPrefAction");
	
/*	helpContentsAction = new QAction( this, "helpContentsAction" );
	helpIndexAction = new QAction( this, "helpIndexAction" );*/
	helpAboutAction = new QAction("&About",QKeySequence(), this, "helpAboutAction" );

	toolBar = new QToolBar( QString(""), this, DockTop );
	MenuBar = new QMenuBar( this, "MenuBar" );

	fileExitAction->addTo( toolBar );
	editFindAction->addTo( toolBar );
	
	fileMenu = new QPopupMenu( this );
/*	fileNewAction->addTo( fileMenu );
	fileOpenAction->addTo( fileMenu );
	fileSaveAction->addTo( fileMenu );
	fileSaveAsAction->addTo( fileMenu );
	fileMenu->insertSeparator();
	filePrintAction->addTo( fileMenu );
	fileMenu->insertSeparator();*/
	fileExitAction->addTo( fileMenu );
	MenuBar->insertItem( QString("&File"), fileMenu, 1 );
	
	editMenu = new QPopupMenu( this );
/*	editUndoAction->addTo( editMenu );
	editRedoAction->addTo( editMenu );
	editMenu->insertSeparator();
	editCutAction->addTo( editMenu );
	editCopyAction->addTo( editMenu );
	editPasteAction->addTo( editMenu );
	editMenu->insertSeparator();*/
	editFindAction->addTo( editMenu );
	editPrefAction->addTo( editMenu );
	MenuBar->insertItem( QString("&Edit"), editMenu, 2 );
	
	helpMenu = new QPopupMenu( this );
/*	helpContentsAction->addTo( helpMenu );
	helpIndexAction->addTo( helpMenu );
	helpMenu->insertSeparator();*/
	helpAboutAction->addTo( helpMenu );
	MenuBar->insertItem( QString("&About"), helpMenu, 3 );
	
	// signals and slots connections
/*	connect( fileNewAction, SIGNAL( activated() ), this, SLOT( fileNew() ) );
	connect( fileOpenAction, SIGNAL( activated() ), this, SLOT( fileOpen() ) );
	connect( fileSaveAction, SIGNAL( activated() ), this, SLOT( fileSave() ) );
	connect( fileSaveAsAction, SIGNAL( activated() ), this, SLOT( fileSaveAs() ) );
	connect( filePrintAction, SIGNAL( activated() ), this, SLOT( filePrint() ) );*/
	connect( fileExitAction, SIGNAL( activated() ), mw, SLOT( fileExit() ) );
/*	connect( editUndoAction, SIGNAL( activated() ), this, SLOT( editUndo() ) );
	connect( editRedoAction, SIGNAL( activated() ), this, SLOT( editRedo() ) );
	connect( editCutAction, SIGNAL( activated() ), this, SLOT( editCut() ) );
	connect( editPasteAction, SIGNAL( activated() ), this, SLOT( editPaste() ) );*/
	connect( editFindAction, SIGNAL( activated() ), mw, SLOT( editFind() ) );
/*	connect( helpIndexAction, SIGNAL( activated() ), this, SLOT( helpIndex() ) );
	connect( helpContentsAction, SIGNAL( activated() ), this, SLOT( helpContents() ) );*/
	connect( helpAboutAction, SIGNAL( activated() ), mw, SLOT( helpAbout() ) );
	connect( editPrefAction, SIGNAL( activated() ), mw, SLOT( editPref() ) );

        QSettings settings;
	QString app_name = APP_NAME;
        int windowWidth = settings.readNumEntry( app_name + "WindowWidth", 460 );
        int windowHeight = settings.readNumEntry( app_name + "WindowHeight", 530 );
        int windowX = settings.readNumEntry( app_name + "WindowX", -1 );
        int windowY = settings.readNumEntry( app_name + "WindowY", -1 );
        resize( windowWidth, windowHeight );
        if ( windowX != -1 || windowY != -1 )
            move( windowX, windowY );
	this->show();

	QString first = settings.readEntry( app_name + "first", "true" );
	if (first=="true")
		QMessageBox::information( this, "cocktail ","You can add your own cocktail recipes in the file located in ~/share/cocktail/cocktails_list.xml.\n Of course, you are free to send me your recipes to be included in the next release of this program.");
	settings.writeEntry(app_name + "first", "false" );

	this->statusBarMessage(QString("%1 recipes loaded").arg(mw->getNbRecipes()));
}


kokMainWindow::~kokMainWindow()
{
}

void kokMainWindow::statusBarMessage(QString text)
{
	this->statusBar()->message( text, 2000 );
}
