/***************************************************************************
 *   Copyright (C) 2005 by Bertrand Haut                                   *
 *   bertrand.haut@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "searchdialogext.h"
#include <qcombobox.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmessagebox.h>

searchDialogExt::searchDialogExt(QStringList allElements,QStringList searchName)
{
	allElements.push_front("");
	this->allElements=allElements;
	this->searchName=searchName;
	comboBoxWith1->insertStringList(allElements);
	comboBoxWithout1->insertStringList(allElements);

	//preselecting a name for the search
	int i=0;
	for (QStringList::iterator it = searchName.begin() ; it !=searchName.end() ;++it)
		if (((*it).startsWith("search")) && !((*it).at(6).isNull() ))
			i=max(i, (*it).at(6).digitValue() );

	searchNameEdit->setText(QString("search%1").arg(i+1));
}


searchDialogExt::~searchDialogExt()
{
}


void searchDialogExt::addMoreWithout(){
	this->addMoreWithoutCombo();
	comboWithout.last()->insertStringList(allElements);
}

void searchDialogExt::addMoreWith(){
	this->addMoreWithCombo();
	comboWith.last()->insertStringList(allElements);
}


void searchDialogExt::accept()
{
	QString searchNameProp =searchNameEdit->text();
	for (QStringList::iterator it = searchName.begin() ; it !=searchName.end() ;++it)
		if ((*it)==searchNameProp){
			QMessageBox::warning ( this, "Warning", "Two different searches may not have the same name.",QMessageBox::Ok,QMessageBox::NoButton);
			return;
		}
	
	bool all=false;
	if (chooseAllorAny->currentText() == "All")
		all =true;

	QStringList with,without;
	for (unsigned i=0 ; i< comboWith.size() ; ++i)
		if (!comboWith[i]->currentText().isEmpty())
			with.append(comboWith[i]->currentText());

	for (unsigned i=0 ; i< comboWithout.size() ; ++i)
		if (!comboWithout[i]->currentText().isEmpty())
			without.append(comboWithout[i]->currentText());

	if (with.isEmpty())
		this->close();
	else
		emit searchRequestEmitted( searchRequest(searchNameProp,with,without,all) );

	cerr << "search requested emitted"<<endl;
	this->close();
}
