/*
**  Document.h
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CodeEditor_H_Document
#define _CodeEditor_H_Document

#include <AppKit/NSDocument.h>

@class NSMutableArray;
@class NSButton;
@class NSTextField;
@class NSWindow;
@class ToolbarView;
@class CodeEditorView;
@class DocumentController;

@interface Document : NSDocument
{
  /* Document Controller */
  DocumentController *documentController;

  /* Document */
  NSString *string;

  /* Window controller */
  NSWindow *window;
  CodeEditorView *currentCEView;

  /* Toolbar */
  ToolbarView *toolbar;
  NSButton *searchButton;
  NSTextField *searchField, *gotoField;

}

/* Document */
- (CodeEditorView *) currentCodeEditorView;

/* Window controller */
- (void) showToolbarView: (id) sender;
- (void) showSideView: (id) sender;
- (void) showFindPanel: (id) sender;
- (void) showInspector: (id) sender;
- (void) showMethodViewer: (id) sender;
- (void) search: (id) sender;
- (void) goto: (id) sender;
- (void) refontify: (id) sender;
/* Mark block around cursor */
- (void) markCurrentBlock: (id) sender;

@end

#endif /* _CodeEditor_H_Document */
