/*
**  PreferenceManager.m
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "PreferenceManager.h"
#include "Utilities.h"
#include <CodeEditorView/CodeEditorViewPreference.h>
#include <AppKit/AppKit.h>

static PreferenceManager *sharedManager;

@implementation PreferenceManager

+ (PreferenceManager *) sharedPreferenceManager
{
  if (!sharedManager)
    {
      sharedManager = [[PreferenceManager alloc] init];
    }
  return sharedManager;
}

- (NSPanel *) preferencePanel
{
  CodeEditorViewPreference *preference 
        = [CodeEditorViewPreferenceClass() sharedCodeEditorViewPreference];

  if (preferencePanel == nil)
    {
      if(NO == [NSBundle loadNibNamed: @"Preference.gorm" owner: self])
        {
           NSBeep();
           return nil;
        }
    }

  /* Load user defaults here */
  tab = [preference tab];
  autoMarkBlock = [preference autoMarkBlock];
  autoFontify = [preference autoFontification];
  autoFontifyWhenTyping = [preference autoFontificationEachLine];
  autoMarkThreshold = [preference autoMarkThreshold];
  autoFontifyThreshold = [preference autoFontificationThreshold];
  autoMarkThresholdCharacters = [preference markThreshold];
  autoFontifyInterval = [preference fontificationInterval];
  autoFontifyThresholdLines = [preference fontificationThreshold];
  autoIndent = [preference autoIndentation];
  displaySideView = [preference displaySideView];

  [self revertEdit: self];
  [self revertFormat: self];
  [self revertDisplay: self];

  return preferencePanel;
}

- (BOOL) runModalPreferencePanel: (id) sender
{
  if ([self preferencePanel] == nil)
    {
       NSBeep();
       return NO;
    }
  [NSApp runModalForWindow: [self preferencePanel]];
  return YES;
}

- (void) insertSpaceAction: (id) sender
{
  if (sender == insertSpaceField)
    {
      if([sender intValue] < 1)
        {
          NSBeep();
          [sender selectText: self];
        }
    }
}

- (void) radioButtonAction: (id) sender
{
  /* Make sure only one button is selected */
  [insertTabButton setState: NO];
  [insertAutoIndentButton setState: NO];
  [insertSpaceButton setState: NO];

  [sender setState: YES];
}

- (void) autoMarkBlockAction: (id) sender
{
  if (sender == autoMarkThresholdField)
    {
      if([sender intValue] < 1)
        {
          NSBeep();
          [sender selectText: self];
        }
    }
  else if (sender == autoMarkBlockButton)
    {
      if([sender state] == NO)
        {
          [autoMarkThresholdButton setState: NO];
          [autoMarkThresholdButton setEnabled: NO];
        }
      else
        {
          [autoMarkThresholdButton setEnabled: YES];
        }
    }
}

- (void) autoFontifyAction: (id) sender;
{
  if (sender == autoFontifyField)
    {
      if([sender intValue] < 1)
        {
          NSBeep();
          [sender selectText: self];
        }
    }
  else if (sender == autoFontifyThresholdField)
    {
      if([sender floatValue] < 1)
        {
          NSBeep();
          [sender selectText: self];
        }
    }
  else if (sender == autoFontifyButton)
    {
      if([sender state] == NO)
        {
          [autoFontifyThresholdButton setState: NO];
          [autoFontifyThresholdButton setEnabled: NO];
        }
      else
        {
          [autoFontifyThresholdButton setEnabled: YES];
        }
    }
}

- (void) revertEdit: (id) sender
{
  /* Make sure only one radio button is selected */
  if ([tab isEqualToString: @"Tab"])
    {
      [self radioButtonAction: insertTabButton];
      if ([[insertSpaceField stringValue] isEqualToString: @""])
        [insertSpaceField setStringValue: @"2"];
    }
  else if ([tab isEqualToString: @"Auto"])
    {
      [self radioButtonAction: insertAutoIndentButton];
      if ([[insertSpaceField stringValue] isEqualToString: @""])
        [insertSpaceField setStringValue: @"2"];
    }
  else
    {
      [self radioButtonAction: insertSpaceButton];
      [insertSpaceField setStringValue: tab];
    }
  [autoMarkBlockButton setState: autoMarkBlock];
  [autoMarkThresholdButton setState: autoMarkThreshold];
  [autoMarkThresholdField setIntValue: (int)autoMarkThresholdCharacters];
  [autoMarkThresholdButton setEnabled: autoMarkBlock];
  [autoIndentButton setState: autoIndent];
}

- (void) revertFormat: (id) sender
{
  [autoFontifyButton setState: autoFontify];
  [autoFontifyThresholdButton setState: autoFontifyThreshold];
  [autoFontifyThresholdButton setEnabled: autoFontify];
  [autoFontifyWhenTypingButton setState: autoFontifyWhenTyping];
  [autoFontifyField setFloatValue: autoFontifyInterval];
  [autoFontifyThresholdField setIntValue: autoFontifyThresholdLines];
}

- (void) revertDisplay: (id) sender
{
  [displaySideViewButton setState: displaySideView];
}

- (void) revertToSaved: (id)sender
{
  id identifier = [[tabView selectedTabViewItem] identifier];
  if ([identifier isEqualToString: @"Edit"])
    [self revertEdit: sender];
  else if ([identifier isEqualToString: @"Format"])
    [self revertFormat: sender];
  else
    [self revertDisplay: sender];
}

- (void) windowWillClose: (NSNotification *) not
{
  CodeEditorViewPreference *preference 
        = [CodeEditorViewPreferenceClass() sharedCodeEditorViewPreference];

  if ([not object] == preferencePanel)
    {
      if ([insertTabButton state])
        tab = @"Tab";
      else if ([insertAutoIndentButton state])
        tab = @"Auto";
      else
        tab = [insertSpaceField stringValue];

      autoMarkBlock = [autoMarkBlockButton state];
      autoMarkThreshold = [autoMarkThresholdButton state];
      autoMarkThresholdCharacters = (unsigned )[autoMarkThresholdField intValue];
      autoFontify = [autoFontifyButton state];
      autoFontifyThreshold = [autoFontifyThresholdButton state];
      autoFontifyWhenTyping = [autoFontifyWhenTypingButton state];
      autoFontifyInterval = [autoFontifyField floatValue];
      autoFontifyThresholdLines = (unsigned)[autoFontifyThresholdField intValue];
      autoIndent = [autoIndentButton state];
      displaySideView = [displaySideViewButton state];

      /* write into class */
      [preference setTab: tab];
      [preference setAutoMarkBlock: autoMarkBlock];
      [preference setAutoMarkThreshold: autoMarkThreshold];
      [preference setMarkThreshold: autoMarkThresholdCharacters];
      [preference setAutoIndentation: autoIndent];
      [preference setAutoFontification: autoFontify];
      [preference setAutoFontificationThreshold: autoFontifyThreshold];
      [preference setAutoFontificationEachLine: autoFontifyWhenTyping];
      [preference setFontificationInterval: autoFontifyInterval];
      [preference setFontificationThreshold: autoFontifyThresholdLines];
      [preference setDisplaySideView: displaySideView];
      
      [NSApp stopModal];
    }
}

- (NSTextField *) insertSpaceField
{
  return insertSpaceField;
}

- (NSButton *) insertSpaceButton
{
  return insertSpaceButton;
}

- (NSButton *) insertTabButton
{
  return insertTabButton;
}

- (NSButton *) insertAutoIndentButton
{
  return insertAutoIndentButton;
}

- (NSButton *) autoMarkBlockButton
{
  return autoMarkBlockButton;
}

- (NSButton *) autoMarkThresholdButton
{
  return autoMarkThresholdButton;
}

- (NSTextField *) autoMarkThresholdField
{
  return autoMarkThresholdField;
}

- (NSButton *) autoIndentButton
{
  return autoIndentButton;
}

- (NSButton *) autoFontifyButton
{
  return autoFontifyButton;
}

- (NSButton *) autoFontifyThresholdButton
{
  return autoFontifyThresholdButton;
}

- (NSTextField *) autoFontifyField
{
  return autoFontifyField;
}

- (NSTextField *) autoFontifyThresholdField
{
  return autoFontifyThresholdField;
}

- (NSButton *) autoFontifyWhenTypingButton
{
  return autoFontifyWhenTypingButton;
}

- (NSButton *) displaySideViewButton
{
  return displaySideViewButton;
}

@end
