/*
**  BundleLoader.m
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju  <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "BundleLoader.h"
#include <Foundation/NSString.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSFileManager.h>
#include <Foundation/NSBundle.h>
#include <Foundation/NSPathUtilities.h>

static BundleLoader *defaultLoader = nil;

/*

NSString *CodeEditorViewBundlePath()
{
  NSString *string;

  string = [NSString stringWithFormat: @"%@/CodeEditorView", 
                      [NSSearchPathForDirectoriesInDomains(GSApplicationSupportDirectory, NSLocalDomainMask, YES)
                                                          objectAtIndex:0] ];

  return string;
}
*/

@implementation BundleLoader

+ (id) defaultLoader
{
  if ( !defaultLoader)
    {
      defaultLoader = [[BundleLoader alloc] init];
    }
  return defaultLoader;
}

- (id) init
{
  self = [super init];
  return self;
}

- (void) dealloc
{
  [super dealloc];
}

// Return all bundles name with specific extension

- (NSArray *) allNamesOfBundles
{
  NSFileManager *fileManager;
  NSArray *allFiles, *array;
  NSMutableArray *allNames;
  NSString *path = nil, *extension = @"bundle";
  int i, count;

  fileManager = [NSFileManager defaultManager];
  allNames = [NSMutableArray new];

  array = NSSearchPathForDirectoriesInDomains(GSApplicationSupportDirectory,
                                              NSAllDomainsMask,
                                              YES);
  count = [array count];
  
  for (i = 0; i < count; i++)
    {
       path = [NSString stringWithFormat: @"%@/%@",
                                     [array objectAtIndex: i],
                                     @"CodeEditorView"];

       if ([fileManager fileExistsAtPath: path])
         break;
    }

  if (path == nil)
    return nil;

  allFiles = [fileManager directoryContentsAtPath: path];

  for (i = 0; i < [allFiles count]; i++)
    {
      NSString *aString;
      
      aString = [allFiles objectAtIndex: i];
      
      // If we found a bundle and the extension is equal, then load it!
      if ( [[aString pathExtension] isEqualToString: extension] )
        {
          [allNames addObject: aString];
        }
    }

  return AUTORELEASE(allNames);
}

// Return the Class name of a specific bundle
- (Class) classNameOf: (NSString *) bundleName
{
  NSBundle *bundle;
  Class bundleClass;
  NSString *path = nil;
  NSFileManager *manager = [NSFileManager defaultManager];
  int i, count;
  NSArray *array = NSSearchPathForDirectoriesInDomains(GSApplicationSupportDirectory,
                                                       NSAllDomainsMask,
                                                       YES);
  count = [array count];
  
  for (i = 0; i < count; i++)
    {
       path = [NSString stringWithFormat: @"%@/%@",
                                     [array objectAtIndex: i],
                                     @"CodeEditorView"];

       if ([manager fileExistsAtPath: path])
         break;
    }

  if (path == nil)
    return Nil;

  path = [NSString stringWithFormat: @"%@/%@", path, bundleName];
  
  bundle = [NSBundle bundleWithPath: path];

  if (bundle)
    {
      bundleClass = [bundle principalClass];

      if ( bundleClass )
        {
          return bundleClass;
        }
      else
        {
          NSLog(@"Failed to get Class from bundle %@", bundleName);
          return nil;
        }
    }

  NSLog(@"BundleLoader: Error loading bundle at path %@", bundleName);
  return nil;
}

@end
