/*
**  PCREParser.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Yen-Ju Chen <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _PCREParser_H_
#define _PCREParser_H_

#include <Foundation/Foundation.h>
#include <pcre.h>

@interface RangeObject: NSObject
{
  @private
  unsigned int _location;
  unsigned int _length;
}

- (unsigned int) location;
- (void) setLocation: (unsigned int) location;
- (unsigned int) length;
- (void) setLength: (unsigned int) length;
- (NSRange) range;
- (void) setRange: (NSRange) range;
@end

enum {
  PCRE_STUDY = 0x1000 // optimize the pattern
};

@interface PCREPattern : NSObject
{
  @private
  pcre *_pcre;
  pcre_extra *_pcreExtra;
  unsigned int _mask;
  const char *error;
  int erroffset;
}

+ (PCREPattern *) pcrePattern: (NSString *) pattern;
- (id) initWithPattern: (NSString *) pattern options: (unsigned int) mask;
- (pcre *) pattern;
- (pcre_extra *) patternExtra;
- (int) numberOfSubpattern;

@end

@interface PCREParser: NSObject
{
  @private
  PCREPattern *_pattern;
  NSString *_string;
  NSRange _range; // The working range, changing all the time
  NSRange _originalRange; // Backup original range
  NSRange _lastMatch; // The last matched range
}

/* The return range is related to the whole string.
 * Not related to the given range.
 * Remember to use NSAutoreleasePool when call it in loop.
 */
+ (NSRange) rangeOfString:(NSString *) pattern
                 inString: (NSString *) string;

+ (NSRange) rangeOfPattern: (PCREPattern *) pattern
                  inString: (NSString *) string;

+ (NSRange) rangeOfString: (NSString *) pattern
                 inString: (NSString *) string
                    range: (NSRange) range;

+ (NSRange) rangeOfPattern: (PCREPattern *) pattern
                  inString: (NSString *) string
                     range: (NSRange) range;

/*
- (id) initWithPattern: (NSString *) string options: (unsigned int)mask;
- (id) initWithPattern: (PCREPattern *) pattern;
- (PCREPattern *) pattern;
- (void) setString: (NSString *)string range: (NSRange) range;
- (NSString *) string;
- (NSRange) range;
- (void) reset;
- (NSRange) rangeOfNextMatch;
- (NSRange) rangeOfPreviousMatch;
- (NSString *) stringOfNextMatch;
- (NSString *) stringOfPreviousMatch;
- (NSArray *) rangesOfNextSubpattern;
- (NSArray *) rangesOfPreviousSubpattern;
- (NSArray *) stringsOfNextSubpattern;
- (NSArray *) stringsOfPreviousSubpattern;
*/

@end

#endif /* _PCREParser_H_ */
