/*
**  ObjCIndentHandler.m
**
**  Copyright (c) 2003
**
**  Author: Yen-Ju  <yjchenx@hotmail.com>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "ObjCIndentHandler.h"
#include <AppKit/AppKit.h>

@implementation ObjCIndentHandler

- (void) string: (NSString *) element
{
  _position += [element length];

  if (_firstWord == nil)
    ASSIGN(_firstWord, element);
}

- (void) number: (NSString *) element 
{
  _position += [element length];
}

- (void) spaceAndNewLine: (unichar) element 
{
  _position += 1/*[element length]*/;
}

- (void) symbol: (unichar) element 
{
  NSString *eStr = [NSString stringWithCharacters: &element length: 1];
  if (_firstWord == nil)
    ASSIGN(_firstWord, eStr);

  /* Calculate the last uneven delimiter */
  _position += 1 /*[element length]*/;

  if ( ([eStr isEqualToString: @"["]) ||
       ([eStr isEqualToString: @"{"]) ||
       ([eStr isEqualToString: @"("]) 
     )
    {
      _whiteSpaces = 2;
    }
  else if ( ([eStr isEqualToString: @"]"]) ||
            ([eStr isEqualToString: @"}"]) ||
            ([eStr isEqualToString: @")"])
          )
    {
      _whiteSpaces = 0;
    }
}

- (void) invisible: (unichar) element
{
  _position += 1/*[element length]*/;
}

- (unsigned int) spaces
{
  if ( ([_firstWord isEqualToString: @"if"]) ||
       ([_firstWord isEqualToString: @"else"]) ||
       ([_firstWord isEqualToString: @"for"]) ||
       ([_firstWord isEqualToString: @"do"]) ||
       ([_firstWord isEqualToString: @"while"])
     )
    {
      return 2;
    }
  return _whiteSpaces;
}

- (id) init
{
  self = [super init];
  return self;
}

- (void) dealloc
{
  RELEASE(_firstWord);
  [super dealloc];
}

@end

