/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id: bstorage.hxx,v 1.2 2006/01/02 22:08:04 zeldan Exp $

#ifndef COMF_BSTORAGE_HXX
#define COMF_BSTORAGE_HXX

#include <stack>
#include <set>
#include <vector>
#include <list>
#include <map>
#include <string>

#include "types.hxx"
#include "object.hxx"
#include "mystd.hxx"

COMF_NS_BEGIN

class BIStorage : public UsedObj
{
	public:
	BIStorage(const ConstSegment &);
	virtual ~BIStorage();

	enum Cmd {BEGIN,END,ABORT};
	
	BIStorage & operator >> (Serializable &);
	BIStorage & operator >> (Cmd);

	BIStorage & operator >> (char &);
	BIStorage & operator >> (unsigned char &);
	BIStorage & operator >> (short &);
	BIStorage & operator >> (unsigned short &);
	BIStorage & operator >> (int &);
	BIStorage & operator >> (unsigned int &);
	BIStorage & operator >> (long &);
	BIStorage & operator >> (unsigned long &);

	BIStorage & operator >> (double &);
	BIStorage & operator >> (bool &);
	BIStorage & operator >> (std::string &);
	
	#ifdef MAKROZ_HASWIDE
	BIStorage & operator >> (std::wstring &);
	#endif

	void checkBitFormat();
	
	protected:
	void read(void *, size_t);
	void skip(size_t);
	const char * ptr() const;

	private:
	const ConstSegment & _data;
	size_t _ptr;
	std::stack<size_t> _blocks;
};


class BOStorage : public Entity
{
	public:
	BOStorage(DynamicSegment &);
	virtual ~BOStorage();

	enum Cmd {BEGIN,END};

	BOStorage & operator << (const Serializable &);
	BOStorage & operator << (Cmd);

	BOStorage & operator << (char);
	BOStorage & operator << (unsigned char);
	BOStorage & operator << (short);
	BOStorage & operator << (unsigned short);
	BOStorage & operator << (int);
	BOStorage & operator << (unsigned int);
	BOStorage & operator << (long);
	BOStorage & operator << (unsigned long);	
	
	BOStorage & operator << (double);
	BOStorage & operator << (bool);
	BOStorage & operator << (const std::string &);
	
	#ifdef MAKROZ_HASWIDE
	BOStorage & operator << (const std::wstring &);
	#endif

	void writeBitFormat();
	
	protected:
	void write(const void *, size_t);
	
	private:
	DynamicSegment & _data;
	size_t _ptr;
	std::stack<size_t> _blocks;
};


template <class X, class Y> BOStorage & operator << (BOStorage & s, const std::pair<X,Y> & a)
{
	return s << a.first << a.second;
}

template <class X, class Y> BIStorage & operator >> (BIStorage & s, std::pair<X,Y> & a)
{
	return s >> a.first >> a.second;
}

template <class T> BOStorage & operator <<(BOStorage & s, const std::vector<T> & a)
{
	s<<a.size();
	typename std::vector<T>::const_iterator i;
	COMF_ITERATEX(i,a) s<<*i;
	return s;
}

template <class T> BIStorage & operator >>(BIStorage & s, std::vector<T> & a)
{
	size_t z;
	s>>z;
	a.resize(z);
	typename std::vector<T>::iterator i;
	COMF_ITERATEX(i,a) s>>*i;
	return s;
}

template <class T> BOStorage & operator <<(BOStorage & s, const std::list<T> & a)
{
	s<<a.size();
	typename std::list<T>::const_iterator i;	
	COMF_ITERATEX(i,a) s<<*i;

	return s;
}

template <class T> BIStorage & operator >>(BIStorage & s, std::list<T> & a)
{
	a.clear();
	size_t z;
	s>>z;
	T x;
	COMF_LOOP(size_t,j,z)
	{
		s >> x;
		a.push_back(x);
	};
	return s;
}



template <class T> BOStorage & operator <<(BOStorage & s, const std::set<T> & a)
{
	s<<a.size();
	typename std::set<T>::const_iterator i;
	COMF_ITERATEX(i,a) s<<*i;
	return s;
}

template <class T> BIStorage & operator >>(BIStorage & s, std::set<T> & a)
{
	a.clear();
	size_t z;
	s>>z;
	T x;
	COMF_LOOP(size_t,j,z)
	{
		s>>x;
		a.insert(x);
	};
	return s;
}


template <class X, class Y> BOStorage & operator <<(BOStorage & s, const std::map<X,Y> & a)
{
	s<<a.size();
	typename std::map<X,Y>::const_iterator i;
	COMF_ITERATEX(i,a) s<<*i;
	return s;
}

template <class X, class Y> BIStorage & operator >>(BIStorage & s, std::map<X,Y> & a)
{
	a.clear();
	size_t z;
	s>>z;
	std::pair<X,Y> t;
	COMF_LOOP(size_t,j,z)
	{
		s>>t;
		a.insert(t);
	};
	return s;
}




COMF_NS_END

#endif
