/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#ifndef COMF_OBJECT_HXX
#define COMF_OBJECT_HXX


#include "defs.hxx"
#include "types.hxx"
#include "globals.hxx"

COMF_NS_BEGIN

//! Serializable class
/*! Inherit from this class to make a class serializable */
class Serializable
{
	protected:
	//! Default constructor 
	Serializable() {}

	//! Default destructor
	virtual ~Serializable() {}

	public:
	//! Serialize to Binary Output Storage
	virtual void serialize(BOStorage &) const = 0;

	//! Serialize from Binary Input Storage
	virtual void serialize(BIStorage &) = 0;
	
	//! Serialize to Text Output Storage
	virtual void serialize(TOStorage &) const = 0;
	
	//! Serialize from Text Input Storage
	virtual void serialize(TIStorage &) = 0;

	//! Get pretty class name
	/*! Should be used to implement text serialization */
	virtual const char * classname() const = 0;
};

#define DECLARE_SERIALIZABLE(T) protected: virtual const char * classname() const {return #T ;}

//! Non copiable class
/*! Inherit from this class to make a class uncopiable */
class Entity
{
	public:
	Entity() {}
	virtual ~Entity() {}
	
	private:
	Entity(const Entity &);
	void operator = (const Entity &);
};


class Private : public Entity
{
	public:

	Private() {}
	virtual ~Private() {}
};


class UsePrivate : public Entity
{
	public:

	UsePrivate();
	virtual ~UsePrivate();
	virtual void private_init() = 0;
	
	protected:
	Private * private_get() const {return _private_data;}
	void private_set(Private *);
	
	private:
	Private * _private_data;
};

#define IMPLEMENT_DEFAULTPRIVATE(CLASSNAME,PRIVNAME) \
void CLASSNAME::private_init() {private_set(new PRIVNAME());}

class UsedObj : public UsePrivate
{
	protected:
	virtual void private_init();
	public:
	UsedObj();
	virtual ~UsedObj();
	void addUser(const void* ptr) const;
	void delUser(const void* ptr) const;
};



class UserObj : public UsePrivate
{
	protected:
	virtual void private_init();
	public:
	UserObj(void * user, const UsedObj & used);
	virtual ~UserObj();
};



COMF_NS_END


#endif
