/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#ifndef COMF_TEST_HXX
#define COMF_TEST_HXX

#include <set>

#include "object.hxx"

#define COMF_CHECKINT(X,F) checkint(__PRETTY_FUNCTION__,#X,#F,X,F)
#define COMF_CHECKREAL(X,F) checkreal(__PRETTY_FUNCTION__,#X,#F,X,F)
#define COMF_CHECKBOOL(X,F) checkbool(__PRETTY_FUNCTION__,#X,#F,X,F)
#define COMF_CHECKSTRING(X,F) checkstring(__PRETTY_FUNCTION__,#X,#F,X,F)


COMF_NS_BEGIN

class Test : Entity
{
	public:
	Test() : _fail(false) {}
	virtual ~Test() {}
	virtual void vrun() = 0;
	bool run();

	protected:

	void checkint(const char * f, const char * expectedname, const char * effectivename, int  expected, int  effective);
	void checkreal(const char * f, const char * expectedname, const char * effectivename, double expected, double effective);
	void checkbool(const char * f, const char * expectedname, const char * effectivename, bool expected, bool effective);
	void checkstring(const char * f, const char * expectedname, const char * effectivename, const std::string & expected, const std::string & effective);

	private:
	bool _fail;
	
};

class TestSuite : Entity
{
	public:
	TestSuite() {}
	virtual ~TestSuite() {}
	void add(Test *);
	bool run();
	
	private:
	std::set<Test*> _tests;
};


COMF_NS_END

#endif

