/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#ifndef COMF_TEXT_HXX
#define COMF_TEXT_HXX

#include <string>

#include "defs.hxx"
#include "types.hxx"
#include "memory.hxx"
#include "file.hxx"
#include "integer.hxx"

COMF_NS_BEGIN

class TextOutput : public UsedObj
{
	public:
	TextOutput() {}
	virtual ~TextOutput() {}

	virtual void write(char) = 0;
	virtual void write(const char *) = 0;
	virtual void writeln() = 0;
	virtual void writeln(const char *) = 0;

	void write(const std::string & str) {write(str.data());}
	void writeln(const std::string & str) {writeln(str.data());}

	static bool valid(char k) {return inco(static_cast<int>(k),32,127);} 
};

class TextInput : public UsedObj
{
	public:
	TextInput(char q = 127) : _q(q) {}
	virtual ~TextInput() {} 

	virtual bool read(std::string &) = 0;
	virtual std::auto_ptr<std::string> read() = 0;

	char validate(char k) {return valid(k) ? k : _q;}

	static bool valid(char k) {return inco(static_cast<int>(k),32,127)||k=='\t';} 

	private:
	char _q;
};



class TextOutputFile : public TextOutput
{
	public:
	TextOutputFile(const char * filename, mode_t mode, size_t growby, t_destructretry drt = 0) :
		_file(filename,true,mode,growby,drt), _ptr(0) {}

	virtual ~TextOutputFile() {}

	virtual void write(char);
	virtual void write(const char *);
	virtual void writeln();
	virtual void writeln(const char *);

	private:
	FileMappingDynamicSegment _file;
	size_t _ptr;

	void writeChar(char);
	
};

class TextInputFile : public TextInput
{
	public:
	TextInputFile(const char * filename, char q, t_destructretry drt = 0) :
		TextInput(q), _file(filename,drt), _ptr(0) {}

	virtual ~TextInputFile() {} 

	virtual bool read(std::string &);
	virtual std::auto_ptr<std::string> read();

	private:
	FileMappingConstSegment _file;
	size_t _ptr;

	int readChar();
};





COMF_NS_END

#endif

