/*
Copyright (C)  2006  Daniele Zelante

This file is part of comf.

comf is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

comf is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with comf; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*@LICENSE*/
// $Id$

#include "../../src/comf.hxx"
#include "../../src/mymacros.hxx"
using namespace comf;

class TestTStorage : public Test
{
	public:
	TestTStorage() {}

	void vrun()
	{
		const_0000();
		int_0000();
		int_0001();
		string_0000();
		block_0000();
	}



	protected:


	void const_0000()
	{
		Memory buffer;
		const char * c = "CHECK";
		{
			TOStorage s(buffer);
			s << c;
		}
	
		{	
			TIStorage s(buffer);
			s >> c;
		}
	}

	void int_0000()
	{
		Memory buffer;
		int c = 12345678;
		{
			TOStorage s(buffer);
			s << c;
		}
	
		int v = 0;
		{
			TIStorage s(buffer);
			s >> v;
		}
		CHECKINT(c,v);
	}

	void int_0001()
	{
		Memory buffer;
		int n = 100;
		{
			TOStorage s(buffer);
			LOOP(int,j,n)
			s << j*j;
		}
	
		{
			TIStorage s(buffer);
			LOOP(int,j,n)
			{
				int k;
				s >> k;
				CHECKINT(j*j,k);		
			}
		}	
	}

	void string_0000()
	{
		Memory buffer;
		std::vector<std::string> v;
		v.push_back(std::string("string"));
		v.push_back(std::string("abc\ndef\rghi\\jkl\'mno\"pqr"));
		const char xxx[] = {1,16,31,32,33,126,127,128,129,-1,-2,0};
		v.push_back(std::string(xxx));
		{
			TOStorage s(buffer);
			CITERATE(std::vector<std::string>,it,v)			
				s << *it;
		}

		{
			TIStorage s(buffer);
			std::string str;
			CITERATE(std::vector<std::string>,it,v)
			{		
				s >> str;
				CHECKSTRING(*it,str);
			}
		}
	}

	void block_0000()
	{
		const int c1 = 12345678;
		const int c2 = 77747774;
		const std::string filename = 
			Format("/tmp/comf_test/%$-TestTStorage_block_0000.txt") % utod(getpid());
		{
			printf("# %s writing\n",filename.data());
			FileMappingDynamicSegment buffer(filename.data(),true,0666,64*1024);
			{	
				TOStorage s(buffer);
				s << TOStorage::DEC;
				s << TOStorage::BEGIN << c1 << TOStorage::END << c2;
				s << TOStorage::POP;
			}
		}
		
		{
			printf("# %s reading 1\n",filename.data());
			FileMappingConstSegment buffer(filename.data());
			int v1 = 0;
			int v2 = 0;
			{
				TIStorage s(buffer);
				try
				{
					s >> TIStorage::BEGIN >> v1 >> TIStorage::END;
				}
				catch(const Exception & xe)
				{
					printf("# exception %s\n",xe.text().data());
					s >> TIStorage::ABORT;
				}
				s >> v2;
				CHECKINT(c1,v1);
				CHECKINT(c2,v2);
			}
		}

		{
			printf("# %s reading 2\n",filename.data());
			FileMappingConstSegment buffer(filename.data());
			int v2 = 0;
			{
				TIStorage s(buffer);
				s >> TIStorage::BEGIN >> TIStorage::ABORT >> v2;
				CHECKINT(c2,v2);
			}
		}

		{
			printf("# %s reading 3\n",filename.data());
			FileMappingConstSegment buffer(filename.data());
			int v1 = 0;
			int v1bis = 0;
			int v2 = 0;
			{
				TIStorage s(buffer);
				try
				{
					s >> TIStorage::BEGIN >> v1 >> v1bis >> TIStorage::END;
				}
				catch(const Exception & xe)
				{
					printf("# exception %s\n",xe.text().data());
					s >> TIStorage::ABORT;
				}
				s >> v2;
				CHECKINT(c1,v1);
				CHECKINT(c2,v2);
			}
		}


	}



};

static TestTStorage s_test_tstorage;


Test * test_tstorage()
{
	return &s_test_tstorage;
}

