# Copyright (C)  2006  Daniele Zelante

# This file is part of makroz.
# 
# makroz is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# makroz is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with makroz; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#@LICENSE
# $Id$


COMMONFLAGS += -shared $(FPIC)

include makroz/common.mk

ifeq ($(shell id -u),0)
	LDCONFIG := ldconfig
else
	LDCONFIG :=
endif


LIBRARY := $(LIBPFX)$(PRODUCT)$(LTSFX)

SONAME := $(LIBRARY)$(SOSFX)
SONAMEV := $(SONAME).$(VERSION)
SONAMEVRB := $(SONAMEV).$(RELEASE).$(BUILDNR)
OSONAMEVRB := .bins/$(SONAMEVRB)$(DLLSFX)


binary: $(OSONAMEVRB)


$(OSONAMEVRB) : $(OBJECTS)
	$(CXX) $(COMMONFLAGS) $(CPPFLAGS) $(LDFLAGS) -o $@ -Wl,-soname=$(SONAMEV) $^ $(LDLIBS)
	cd .bins; $(SYMLINK) $(SONAMEVRB) $(SONAMEV); $(SYMLINK) $(SONAMEVRB) $(SONAME)


install_lib: $(OSONAMEVRB)
	$(MKDIR) $(PREFIX)/lib
	install -p $(OSONAMEVRB) $(PREFIX)/lib
	cd $(PREFIX)/lib; $(SYMLINK) $(SONAMEVRB) $(SONAMEV)
	cd $(PREFIX)/lib; $(SYMLINK) $(SONAMEVRB) $(SONAME)
	$(LDCONFIG)


