---
title: 'ComPlot: Comparison Plotter to visually evaluate ocean model
simulations'
authors:
  - name: Marco van Hulten
    orcid: 0000-0002-3045-4949
    affiliation: 1, 2
affiliations:
  - name: Geophysical Institute, University of Bergen, and Bjerknes
    Centre for Climate Research, Bergen, Norway
    index: 1
  - Laboratoire des Sciences du Climat et l'Environnement,
    Gif-sur-Yvette, France
    index: 2
output:
  pdf_document:
    fig_caption: no
---
\title{Comparison Plotter to visually evaluate ocean model simulations}
\author{Marco van Hulten}

\maketitle

![ComPlot logo](logo.png)

# Summary

ComPlot is a library of Ferret scripts that aims to create intuitive
plots comparing one or more model outputs with one or more observational
datasets.
The main purpose of ComPlot is to *comp*are model results with data by
*plot*ting the data onto the model output as dots.
It is meant for oceanographers who want to compare ocean model output
with observations, and do so in freedom.
ComPlot is free software.
This means you are free to run it, to study and change it, and to
redistribute copies with or without changes.

ComPlot has been used in several papers, among which [@vanHulten2017].

# Background

There is a lot of visualisation software available, ranging from general
plotting languages and programs with low-level visualisation libraries,
to more specific programs and libraries specialised for specific
purposes.
Popular visualisation libraries include matplotlib [@Hunter2007]
(Python) and ggplot2 [@Wickham2016] (R).
There are also many web solutions available, typically written in
JavaScript.
One example of such a solution is D3.js, and a more specialised example
is a *clickable, sortable, stacked bar chart* [i1] based on the
*Stacked Bar Chart* [i2].

[i1]: http://bl.ocks.org/katirg/f7d064cd9c3efbc3c360
[i2]: https://bl.ocks.org/mbostock/3886208

Ocean and atmosphere model output is typically saved on irregular grids
in NetCDF files [i3].
Many languages and packages can load NetCDF files, and often it is also
possible, albeit with some effort, to convert this to a regular lon-lat
grid and plot it on the screen.
One approach is using Python [i4] with one of the NetCDF packages and
matplotlib [i5].
If the grid data is stored in the NetCDF file, it should be possible to
plot the model data from an irregular grid onto a regular grid.
With some effort observational data could be plotted onto that for
comparison, but the author does not know of user-ready libraries that
have that capability.

[i3]: http://www.unidata.ucar.edu/downloads/netcdf/
[i4]: https://www.python.org/
[i5]: http://matplotlib.org/

Plotting of ocean and atmosphere model data should be easy.
For quick viewing there is ncview(1), but that does not regrid the data,
and it is very limited otherwise as well (it is meant for quickly
viewing the data on the screen).
Here comes in Ferret, a visualisation and analysis tool for oceanography
and meteorology [@Hankin1996].
Ferret can easily convert an irregular grid to a regular lon-lat grid
(or a polar plot) by including the argument `,nav_lon,nav_lat` if the
map is stored in the variables `nav_lon` and `nav_lat`.
The default plotting settings are quite sane but usually not beautiful
enough for a paper or a slide.
With some effort one can make plot beautiful, and through the *PPLUS*
library, included in the standard Ferret distribution, one can change
many of the visualisation properties of the plot.
However, a quick search through the Ferret mailinglist
(\url{http://www.ferret.noaa.gov/Ferret/email-users-group}) shows that
PPLUS is unpredictable for those who are no experts in PPLUS.

PyFerret is a wrapper, written in Python, around Ferret
(\url{http://www.ferret.noaa.gov/Ferret/documentation/pyferret/what-is-pyferret}).
This brings Python functionality to Ferret, and the graphics backend is
modernised.
Both Ferret and Python users may want to have a look at this software.

Arguably, another shortcoming of visualisation software, when used by
ocean and atmosphere modellers, is that there is no generic way to load
model output files and obervational datasets (if one wants to compare
model with data).
One may of course define the right data structures themselves, be it
within the classical Ferret language or PyFerret, but that does not
provide the user with a ready, standard way to (meta)structure the data.

That is where *ComPlot* comes in.
ComPlot is a collection of Ferret scripts to easily plot model output
and data as coloured dots on top of it.
From the one hand this is a rather specific capability, but one that is
very useful for visual inspection of the goodness-of-fit of the model.
Plots made with ComPlot should always be amended with statistical
goodness-of-fits, like a correlation coefficient or a reliability index
[@Stow2009].
One should realise that such statistical numbers try to reduce the full
complexity of a model--data comparison to a single number; ComPlot
presents much more, albeit at a single section of the ocean and with an
uncertainty of the discretisation used of the key (or the human eye if
the key is too fine) and the resolution defined by ComPlot (zonal,
latitudinal or depth range).
Other features/advantages of ComPlot include:

- model files and observational data are loaded in a structured manner;
- plotting of profile with `render_profile.jnl`;
- plotting of horizontal section with `render_layer.jnl`;
- plotting of arbitrary vertical transects with `render_transect.jnl`;
- adjustable delta to include more or less observations near the section
  or profile (model data averages over same region);
- higher-level user scripts `c2d_*.jnl` (compare to data);
- adjustable visual properties through `init_visuals.jnl`.

See `README.md` from the
[ComPlot](https://savannah.nongnu.org/projects/complot/)
repository for further details [repos].

[repos]: http://hg.savannah.nongnu.org/hgweb/complot/

# Acknowledgement

When parts of this code is used, please refer to this paper and the code
repository.
Where appropriate, also consider the scientific literature cited in this
package.

Many people in the Ferret community, roughly those participating through
<ferret_users@noaa.gov>, have helped a lot mostly by giving advice on
how to do things in Ferret.
Discussion with and advice from Ansley Manke (NOAA) and Patrick
Brockmann (LSCE) were especially useful, but do search the
[archives](http://ferret.pmel.noaa.gov/Ferret/email-users-group) to find
out how helpful the whole community is.

# Copying

Concerning this paper, including the logo (`logo.*`):

Copyright (C) 2017 [Marco van Hulten](mailto:marco@klimato.org).

You may reuse this document according to the conditions given by the
[Creative Commons Attribution--ShareAlike
3.0](https://creativecommons.org/licenses/by-sa/3.0/)
(`data/CC-BY-SA-3.0.txt`).

# References

\bibliography{paper.bib}{}

