---
title: 'ComPlot: Comparison Plotter to visually evaluate ocean model
simulations'
authors:
  - name: Marco van Hulten
    orcid: 0000-0002-3045-4949
    affiliation: 1, 2
affiliations:
  - name: Geophysical Institute, University of Bergen, and Bjerknes Centre for Climate Research, Bergen, Norway
    index: 1
  - name: Laboratoire des Sciences du Climat et l'Environnement, Gif-sur-Yvette, France
    index: 2
output:
  pdf_document:
    fig_caption: no
date: 30 August 2017
bibliography: paper.bib
---

![](logo.svg)

# Summary

ComPlot is a library of Ferret scripts that aims to create intuitive
plots comparing one or more model outputs with one or more observational
datasets.
The main purpose of ComPlot is to *comp*are model results with data by
*plot*ting the data onto the model output as dots.
It is meant for oceanographers who want to compare ocean model output
with observations, and do so in freedom.
ComPlot is free software.
This means you are free to run it, to study and change it, and to
redistribute copies with or without changes.

ComPlot has been used in several papers, among which [@vanHulten2017].

# Background

There is a lot of visualisation software available, ranging from general
plotting languages and programs with low-level visualisation libraries,
to more specific programs and libraries specialised for specific
purposes.
Popular visualisation libraries include matplotlib [@Hunter2007]
(Python) and ggplot2 (R) [@Wickham2016].
There are also many web solutions available, typically written in
JavaScript.
One example of such a solution is D3.js, and a more specialised example
is a [clickable, sortable, stacked bar chart][i1] based on the
[Stacked Bar Chart][i2].

[i1]: http://bl.ocks.org/katirg/f7d064cd9c3efbc3c360
[i2]: https://bl.ocks.org/mbostock/3886208

Ocean and atmosphere model output is typically saved on irregular grids
in [NetCDF files][i3].
Many languages and packages can load NetCDF files, and often it is also
possible, albeit with some effort, to convert this to a regular lon-lat
grid and plot it on the screen.
One approach is using [Python][i4] with one of the NetCDF packages and
[matplotlib][i5].
If the grid data is stored in the NetCDF file, it should be possible to
plot the model data from an irregular grid onto a regular grid.
With some effort observational data could be plotted onto that for
comparison, but the author does not know of user-ready libraries that
have that capability.

[i3]: https://www.unidata.ucar.edu/software/netcdf/
[i4]: https://www.python.org/
[i5]: http://matplotlib.org/

Plotting of ocean and atmosphere model data should be easy.
For quick viewing there is ncview(1), but that does not regrid the data,
and it is very limited otherwise as well (it is meant for quickly
viewing the data on the screen).
Here comes in Ferret, a visualisation and analysis tool for oceanography
and meteorology [@Hankin1996].
Ferret can easily convert an irregular grid to a regular lon-lat (or
polar) grid by including the argument `,nav_lon,nav_lat` if the
map is stored in the variables `nav_lon` and `nav_lat`.
The default plotting settings are quite sane but usually not beautiful
enough for a paper or a slide.
With some effort one can make plot beautiful, and through the *PPLUS*
([PLOT
PLUS](http://ferret.pmel.noaa.gov/Ferret/documentation/users-guide/appendix-b-pplus-guide/appendix-b-pplus-guide))
library, included in the standard Ferret distribution, one can change
many of the visualisation properties of the plot.
However, a quick search through the [Ferret
mailinglist](http://www.ferret.noaa.gov/Ferret/email-users-group) shows
that the interaction between PPLUS and Ferret is unpredictable, at least
for those who are no experts in PPLUS.

[PyFerret](http://www.ferret.noaa.gov/Ferret/documentation/pyferret)
is a wrapper, written in Python, around Ferret.
This brings Python functionality to Ferret, and the graphics backend is
modernised.
Both Ferret and Python users may want to have a look at this software.

Arguably, another shortcoming of visualisation software, when used by
ocean and atmosphere modellers, is that there is no generic way to load
model output files and obervational datasets (if one wants to compare
model with data).
One may of course define the right data structures themselves, be it
within the classical Ferret language or PyFerret, but that does not
provide the user with a ready, standard way to (meta)structure the data.

That is where *ComPlot* comes in.
ComPlot is a collection of Ferret scripts to easily plot model output
and data as coloured dots on top of it.
The following figure from [@vanHulten2017] is an example of a ComPlot plot.
This is a rather specific capability, but one that is
very useful for visual inspection of the goodness-of-fit of the model.
Plots made with ComPlot should always be amended with statistical
goodness-of-fits, like a correlation coefficient or a reliability index
[@Stow2009].
One should realise that such statistical numbers try to reduce the full
complexity of a model--data comparison to a single number; ComPlot
presents much more, albeit at a single section of the ocean and with an
uncertainty of the discretisation used of the key (or the human eye if
the key is finer than that) and the resolution defined by ComPlot (zonal,
latitudinal or depth range).

![*Figure 1:* Dissolved Mn at four depths, model and observations [@vanHulten2017]](mang.png).

Other features/advantages of ComPlot include:

- model files and observational data are loaded in a structured manner;
- plotting of profile with `render_profile.jnl`;
- plotting of horizontal section with `render_layer.jnl`;
- plotting of arbitrary vertical transects with `render_transect.jnl`;
- adjustable delta to include more or less observations near the section
  or profile (model data averages over same region);
- higher-level user scripts `c2d_*.jnl` (compare to data);
- adjustable visual properties through `init_visuals.jnl`.

See [README.md](http://www.nongnu.org/complot/) from the
[ComPlot](https://savannah.nongnu.org/projects/complot/)
[repository][repos] for further details.

[repos]: http://hg.savannah.nongnu.org/hgweb/complot/

# Acknowledgement

Many people in the Ferret community have helped a lot mostly by giving
advice on how to do things in Ferret.
Discussion with and advice from Ansley Manke (NOAA) and Patrick
Brockmann (LSCE) were especially useful, but do search the [mailing list
archives](http://ferret.pmel.noaa.gov/Ferret/email-users-group) to find
out how helpful the whole community is.

This development of this code was supported by a Swedish Research
Council grant (349-2012-6287) in the framework of the French--Swedish
cooperation in the common research training programme in the climate,
environment and energy agreement between VR and LSCE, for the project
*Particle transport derived from isotope tracers and its impact on ocean
biogeochemistry: a GEOTRACES project in the Arctic Ocean*.
Final development was supported by the project *Overturning circulation
and its implications for the global carbon cycle in coupled models*
(ORGANIC, The Research Council of Norway, grant no. 239965).

# Copying

Concerning this paper, including the logo (`logo.*`):

Copyright (C) 2017 [Marco van Hulten](mailto:marco@klimato.org).

You may reuse this document according to the conditions given by the
[Creative Commons Attribution
4.0](https://creativecommons.org/licenses/by/4.0/)
(`CC-BY-4.0.txt`), or, at your option, the [Creative Commons
Attribution--ShareAlike 3.0](https://creativecommons.org/licenses/by-sa/3.0/)
(`data/CC-BY-SA-3.0.txt`).

# References

