/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSADDRESS_H
#define CONEXUSADDRESS_H

#include <sys/types.h>
#include <sys/socket.h>

namespace conexus {

/**
 * This top level class provides a pure-virtual inheritance interface for children to inherit from.
 *
 * In concept, this class is much like the BSD raw sockaddr structure.
 * @author Rick L Vinyard Jr
 * @ingroup conexus
 */
class Address
{
public:
    Address();

    ~Address();

    /**
     * @return the raw sockaddr structure of this address type
     */
  virtual struct sockaddr* get_raw_address() = 0;

  /**
   * @return the length of the raw sockaddr structure in bytes
   */
  virtual socklen_t get_raw_address_size() const = 0;

  /**
   * @return true if this is considered a broadcast address
   *
   * Is relative to a specific child protocol implementation and returns false unless
   * child provides a specific implementation.
   */
  virtual bool is_broadcast() const;

};

}

#endif
