/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CONEXUSCLOSE_ERROR_H
#define CONEXUSCLOSE_ERROR_H

#include <conexus/error.h>

namespace conexus {

/**
 * Base class for all close errors.
 * @author Rick L Vinyard Jr
 * @ingroup errors
 */
class close_error: public conexus_error {
public:
close_error(int e=0): conexus_error("Unknown error, socket cannot be closed.",e,"close") { }
close_error(const std::string s, int e=0): conexus_error(s,e,"close") { }
}
;

namespace error {


namespace close {

/**
 * EBADF: Thrown when equivalent BSD socket API error is encountered. May be caught alone
 * or via parent class.
 * @author Rick L Vinyard Jr
 * @ingroup errors
 */
class bad_fd: public close_error {
public:
  bad_fd(): close_error("fd isn’t a valid open file descriptor.", EBADF) { }
}
;

/**
 * EINTR: Thrown when equivalent BSD socket API error is encountered. May be caught alone
 * or via parent class.
 * @author Rick L Vinyard Jr
 * @ingroup errors
 */
                class interrupted: public close_error {
public:
  interrupted(): close_error("The close() call was interrupted by a signal.", EINTR) {}
}
;

/**
 * EIO: Thrown when equivalent BSD socket API error is encountered. May be caught alone
 * or via parent class.
 * @author Rick L Vinyard Jr
 * @ingroup errors
 */
class io: public close_error {
public:
  io(): close_error("An I/O error occurred.", EIO) { }
}
;

}
}
}
#endif
