/***************************************************************************
 *   Copyright (C) 2001 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "filedescriptor.h"

#include <errno.h>

using namespace conexus;

FileDescriptor::FileDescriptor(int fd, bool close_on_destruction): IO(close_on_destruction), m_fd(fd)
{
  m_timeval.tv_sec = 0;
  m_timeval.tv_usec = 5000;
}


FileDescriptor::~FileDescriptor()
{
  if (m_close_on_destruction && is_open() )
    close();
}

int FileDescriptor::get_fd() throw () {
  return m_fd;
}

void FileDescriptor::close() throw (close_error) {
  int i = ::close(m_fd);
  if (i == -1)
    throw_close_error(errno);

  set_state_closed();
}

void FileDescriptor::set_responsiveness(long r) {
  m_timeval.tv_usec = r;
}

long FileDescriptor::get_responsiveness() {
  return m_timeval.tv_usec;
}

void FileDescriptor::service_thread_main() {
  int n;
  Data d, dcpy;
  std::set<FileDescriptor*>::iterator i;
  struct timeval tv;
  fd_set readfd;

  if (m_fd < 0)
    throw;

  while (!m_terminate) {
    FD_ZERO(&readfd);
    FD_SET(m_fd, &readfd);

    if (m_timeval.tv_usec <= 0)
      n = select(m_fd+1, &readfd, NULL, NULL, NULL);
    else {
      tv = m_timeval;
      n = select(m_fd+1, &readfd, NULL, NULL, &tv);
    }
    if (FD_ISSET(m_fd, &readfd))
      queue_received_data(read());
  }
  m_running = false;
}

